/* loadsave.cpp

	 Loading and saving a genetic program with all the structure intact...

	 Designed By Adam Fraser 20/08/93 for the genetic programming system... */

/* Genetic Programming System using the C++ programming language

 Input is of the form gp <pop> <gen> <output file>

 A Potted History:

	 Version 1.00 BETA (sometime March 1993). Very Buggy,...
	 Version 2.00 C++ version very easy language 16 July 1993
								ERRORS in load and saving a genetic program.
											 No capacity for extended memory in DOS.
											 No differing creation mechanism.
											 No touranment selection
											 No capacity for encapsulation
	 Version 3.00 C++ Version.( Uncompatible with previous versions )
											 Robust with full use of OOP techniques.
											 Compatibility with ANSI standard.
											 Ramped half and half implemented.
											 Tournament selection implemented.
											 Changing variables does not require recompiling.
											 BUT STILL
											 No capacity for expanded or extended memory in DOS.
											 No capacity for encapsulation.

	 C version in progress
	 Windows version in progress but its all gobblydegook.


	 Version 3.00 can be compiled in the DOS and UNIX domain
	 but NOT in Windows. This was not made clear in previous programs.

 Genetic programming in C++ was designed and choreographed by Adam P.Fraser

		Food parcels, cash and trashy sci-fi novels to:

					 a.fraser@eee.salford.ac.uk
					snail:
					 A.Fraser
					 PostGraduate Section,
					 Maxwell Building,
					 Elec & Elec Eng,
					 University Of Salford,
					 Salford,
					 M5 4WT.
					 England


		Your comments, improvements and complaints are welcome.


 This code is intended as a base for C++ GPers. Please if you adapt the code
 send me a msg. Also could you please keeps these comments and my address in
 the code.

							regards,
											Adam Fraser ;-)
											16 November 1993

	' and one day there shall come an artificial ant who can complete the santa
	fe trail in 400 evaluation steps and on that day there shall be oink flap'
*/

#include "gpmain.hpp"

ostream& GP::Save( ostream& os )
{
	if ( pgHeader )	pgHeader->Save( os );

	os << endl << iLength << " " << iFitness << endl;

	return os;
}

ostream& Gene::Save( ostream& os )
{
	os << iValue << " ";

	if ( pgChild ) { os << "c "; pgChild->Save( os ); }
	else           os << "o ";

	if ( pgNext )  { os << "n "; pgNext->Save( os ); }
	else           os << "o ";

	return os;
}


istream& GP::Load( istream& is )
{
	if ( !(pgHeader = new Gene) ) ExitSystem( "GP::Load" );

	pgHeader->Load( is );

	is >> iLength >> iFitness;

	return is;
}

istream& Gene::Load( istream& is )
{
	char ch;

	is >> iValue;

	is >> ch;

	if ( ch == 'c' )
	{
		if ( !(pgChild = new Gene) ) ExitSystem( "Gene::Load" );
		pgChild->Load( is );
	}

	is >> ch;

	if ( ch == 'n' )
	{
		if ( !(pgNext = new Gene) ) ExitSystem( "Gene::Load" );
		pgNext->Load( is );
	}

	return is;
}


/* loadsave.c */