// gene.hpp library defn's for genetic programming system

#ifndef __GENE

#define __GENE

#include <iostream.h>

struct Gene
{
	unsigned int iValue;      // if more than 65535 program blocks, change!!!
	Gene 	*pgChild,
				*pgNext;
	friend ostream& operator << ( ostream& , Gene* );

public:

	Gene( int = 0 );
	Gene( Gene* );                      // new copy with no connection
	~Gene();
	void Copy( Gene* );                 // overwriting copy;
	void CreateVariable( int );                  // create.cpp
	void CreateVariableChildren( int, int );
	void CreateGrow( int );
	void CreateGrowChildren( int, int );
	void Length( int& );
	Gene* Nth();
	int Depth( int, int& );
	int Compare( Gene*, int );
	int Evaluate();
	ostream& Save( ostream& os );
	istream& Load( istream& is );
};


#ifdef DEBUG
	#define DebugPrint( msg )	     cout << msg << endl;
#else
	#define DebugPrint( msg )
#endif


extern void ExitSystem( char * );  		    // defined in exit.cpp

extern int EvaluateFitness( Gene*, int );    // defined in evolving code
extern int Translate( Gene* );
extern char *TranslatePrint( Gene* );
extern void Initialise();       // defined in evolving code

#endif