#include "function.hpp"

// function.cpp

// By Adam Fraser 7/06/93

// Function Set system using C++ and all the ease of OOP programming
// 	 for use in the Genetic Program system

/* Genetic Programming System using the C++ programming language

 Input is of the form gp <pop> <gen> <output file>

 A Potted History:

	 Version 1.00 BETA (sometime March 1993). Very Buggy,...
	 Version 2.00 C++ version very easy language 16 July 1993
								ERRORS in load and saving a genetic program.
											 No capacity for extended memory in DOS.
											 No differing creation mechanism.
											 No touranment selection
											 No capacity for encapsulation
	 Version 3.00 C++ Version.( Uncompatible with previous versions )
											 Robust with full use of OOP techniques.
											 Compatibility with ANSI standard.
											 Ramped half and half implemented.
											 Tournament selection implemented.
											 Changing variables does not require recompiling.
											 BUT STILL
											 No capacity for expanded or extended memory in DOS.
											 No capacity for encapsulation.

	 C version in progress
	 Windows version in progress but its all gobblydegook.


	 Version 3.00 can be compiled in the DOS and UNIX domain
	 but NOT in Windows. This was not made clear in previous programs.

 Genetic programming in C++ was designed and choreographed by Adam P.Fraser

		Food parcels, cash and trashy sci-fi novels to:

					 a.fraser@eee.salford.ac.uk
					snail:
					 A.Fraser
					 PostGraduate Section,
					 Maxwell Building,
					 Elec & Elec Eng,
					 University Of Salford,
					 Salford,
					 M5 4WT.
					 England


		Your comments, improvements and complaints are welcome.


 This code is intended as a base for C++ GPers. Please if you adapt the code
 send me a msg. Also could you please keeps these comments and my address in
 the code.

							regards,
											Adam Fraser ;-)
											16 November 1993

	' and one day there shall come an artificial ant who can complete the santa
	fe trail in 400 evaluation steps and on that day there shall be oink flap'
*/


// #define TEST

// Print functions... using ostream

ostream& operator << ( ostream& os, Function *pf )
{
	os << "Function: " << pf->iFunction << " Args: " << pf->iArguments << endl;
	return os;
}

ostream& operator << ( ostream& os, FS *pfs )
{
	if ( pfs )
	{
		Function *pf = pfs->pfHeader;

		while (	pf ) { os << pf;  pf = pf->pfNext;	}
	}
	return os;
}


Function::Function()
{
	iFunction = 0;
	iArguments = 0;
	pfNext = NULL;
}

FS::FS()
{
	pfHeader = NULL;
}

FS::FS( int noofargs, ... )
{
	va_list ap;                               // ap =  variable list
	Function *pf;

	va_start( ap, noofargs );	                // necessary for variable list

	if ( noofargs == 0 ) return;			        // why would anyone do this

	if ( !(pfHeader = new Function) ) ExitSystem( "FS::FS" );

	pfHeader->iFunction = va_arg( ap, int );  // read off a value

	pf = pfHeader;                            // reset to start for args

	for ( int i = 1; i < noofargs; i++)
	{
		if ( !(pf->pfNext = new Function) ) ExitSystem( "FS::FS" );
		pf = pf->pfNext;
		pf->iFunction = va_arg( ap, int );      // read next value
	}

	pfHeader->iArguments = va_arg( ap, int );

	pf = pfHeader;

	for ( i = 1; i < noofargs; i++)
	{
		pf = pf->pfNext;
		pf->iArguments = va_arg( ap, int );
	}

	va_end( ap );                             // necessary for variable list
}


FS::~FS()
{
	if ( this )
	{
		Function *pf = pfHeader, *pfOld = pfHeader;

		while ( pf )
		{
			pf = pfOld->pfNext;
			delete pfOld;
			pfOld = pf;
		}
	}
}

int FS::Length()
{
	int count = 0;
	Function *pf = pfHeader;

	while ( pf )	{ pf = pf->pfNext; count++;	}

	return count;
}

// Up to the programmer to make sure n is below total length of function set
Function* FS::Nth( int n )
{
	Function *pf= pfHeader;

	for ( int i = 1; i < n; i++ ) pf = pf->pfNext;

	return pf;
}

// This function would probably have been better written with loads of temp
//  variables my software eng lecturer of yesteryear would not be happy...
// Basically this chooses a value from the Function set... APF 7/03/93

Function* FS::Choose()
{
	return ( Nth( ( rand() %  Length() ) + 1 ) );
}

#ifdef TEST

// test main() code for functions in this section

main(void)
{
	FS *FunctionSet = new FS( 4, 1,2,3,4, 4,3,2,1 );

	cout << FunctionSet;

	cout << FunctionSet->Length() << endl;

	cout << function( FunctionSet->Nth(3) ) << endl;

	cout << arguments( FunctionSet->Nth(1) ) << endl;

	cout << function( FunctionSet->Choose() ) << endl;

	return 0;
}

#endif

// function.cpp


