/*******************************************************************
**                                                                **
**                    Genetic Library                             **
**                                                                **
**   A library of functions to give an environment for Genetic    **
**                      Algorithms.                               **
**                                                                **
**  While these functions were designed to be used in the field   **
**  of neural networks, they could easily (hopefully) be used on  **
**   other types of optimisations.  The library implements both   **
**   a 1-stage GA and a 2-stage GA. A one stage GA is a GA where  **
**   you only have one population, in a 2-stage GA you may have   **
**  several populations, and a "master" population wich controls  **
**                 the "sub" poulations.                          **
**                                                                **
**        This library has been implemented and tested on:        **
**                                                                **
**           IBM RS/6000 & AIX 3.2 & GCC 2.5.7                    **
**                                                                **
**                 PC & DOS 6.2 % MSC 7.0                         **
**                                                                **
**   This software is part of my Diplomarbeit at the University   **
**  Kassel, Researchgroup Neural Networks.  The software may be   **
**   used for academic and educational purposes.  The use in a    **
**   corporate environment depends on the written permission of   **
**   the author.  I give no warranty for the functions in this    **
**        library, although all have been tested.                 **
**                                                                **
**      You may alter the files in this library, but are not      **
**    permitted to redistribute the files under their original    **
**  name.  If you write additions to this library and would like  **
**    them to be included in future releases, contact me, I'll    **
**           include them and give you credit.                    **
**                                                                **
**      Send questions, bugs, requests for new features and       **
**                      additions to                              **
**                                                                **
**         jochenr@neuro.informatik.uni-kassel.de                 **
**                   University Kassel                            **
**                 FG Neuronale Netzwerke                         **
**                     Jochen Ruhland                             **
**                Heinrich-Plett-Str.  40                         **
**                     D-34132 Kassel                             **
**                        Germany                                 **
**                                                                **
*******************************************************************/
/* Setzen des Target-Vektors
*/

#include "vartop.h"

struct target targets[N_TARGET];

#define ON      0.9F
#define OFF     0.1F
#define NC      1.0F

void set_target()
{
    targets[0].input[0] = OFF;
    targets[0].input[1] = OFF;
    targets[0].input[2] = NC;
    targets[0].output[0] = OFF;

    targets[1].input[0] = OFF;
    targets[1].input[1] = ON;
    targets[1].input[2] = NC;
    targets[1].output[0] = ON;

    targets[2].input[0] = ON;
    targets[2].input[1] = OFF;
    targets[2].input[2] = NC;
    targets[2].output[0] = ON;

    targets[3].input[0] = ON;
    targets[3].input[1] = ON;
    targets[3].input[2] = NC;
    targets[3].output[0] = OFF;

}


