/*******************************************************************
**                                                                **
**                    Genetic Library                             **
**                                                                **
**   A library of functions to give an environment for Genetic    **
**                      Algorithms.                               **
**                                                                **
**  While these functions were designed to be used in the field   **
**  of neural networks, they could easily (hopefully) be used on  **
**   other types of optimisations.  The library implements both   **
**   a 1-stage GA and a 2-stage GA. A one stage GA is a GA where  **
**   you only have one population, in a 2-stage GA you may have   **
**  several populations, and a "master" population wich controls  **
**                 the "sub" poulations.                          **
**                                                                **
**        This library has been implemented and tested on:        **
**                                                                **
**           IBM RS/6000 & AIX 3.2 & GCC 2.5.7                    **
**                                                                **
**                 PC & DOS 6.2 % MSC 7.0                         **
**                                                                **
**   This software is part of my Diplomarbeit at the University   **
**  Kassel, Researchgroup Neural Networks.  The software may be   **
**   used for academic and educational purposes.  The use in a    **
**   corporate environment depends on the written permission of   **
**   the author.  I give no warranty for the functions in this    **
**        library, although all have been tested.                 **
**                                                                **
**      You may alter the files in this library, but are not      **
**    permitted to redistribute the files under their original    **
**  name.  If you write additions to this library and would like  **
**    them to be included in future releases, contact me, I'll    **
**           include them and give you credit.                    **
**                                                                **
**      Send questions, bugs, requests for new features and       **
**                      additions to                              **
**                                                                **
**         jochenr@neuro.informatik.uni-kassel.de                 **
**                   University Kassel                            **
**                 FG Neuronale Netzwerke                         **
**                     Jochen Ruhland                             **
**                Heinrich-Plett-Str.  40                         **
**                     D-34132 Kassel                             **
**                        Germany                                 **
**                                                                **
*******************************************************************/
/* Genetic operators */
/* Stage 0 - Low-Level Funktionen */
/* Erweiterung auf mehrere Populationen gleichzeitig */

#include "debug.h"

#ifndef __USHORT
#define __USHORT
typedef unsigned short USHORT;
#endif

extern void __randomize_popelem(USHORT *p, int size);

/* Groesse in Bytes! */
extern void set_mask(int sizemask);

/* Kopiert eins auf's andere */
extern void __copy_popelem(USHORT *source, USHORT *destination, int size);

/* Kippt mit p_kipp die Bits in p */
extern void __mutate(USHORT *p, float p_kipp, int size);

/* erzeugt s aus v und m, nimmt numbits von v */
extern void __crossover(USHORT *v, USHORT *m, USHORT numbits,
			    USHORT *s, USHORT size);

/* erzeugt s aus v und m, nimmt n1 bis n2 bits von m */
extern void __crossover2(USHORT *v, USHORT *m, USHORT n1, USHORT n2,
			     USHORT *s, USHORT size);

/* erzeugt s aus v und m, nimmt mit Wahrscheinlicheketi p_vat von v */
extern void __crossovern(USHORT *v, USHORT *m, double p_vat, USHORT *s, int size);

extern int __hamming_diff(USHORT *p1, USHORT *p2, int size);

