function s = sumc(m)
% SUMC Always sums columns.
%
% SUMC(M)
%   M - Matrix.
% Returns sum of columns.
%
% This function is very similar to SUM, but it does
%   NOT switch to row summing if called with a row vector.
%
% EXAMPLE: m = [1 2 3; 4 2 2];
%          s = sumc(m)

% Mark Beale 6-24-93
% Copyright (c) 1993 by PWS Publishing Company

[mr,mc] = size(m);

if mr == 1
  s = m;
else
  s = sum(m);
end


