function g=rectangl(s,v)
% RECTANGL Evaluates rectangular shaped fuzzy sets.
%
% RECTANGL(S,[A1,B1; A2 B2; ...; An,Bn])
%   S -  Row vector of support values.
%   Ai - Threshold support value for ith grade vector.
%   Bi - Cutoff support value for ith grade vector.
% Returns n grade vectors with values of 1 in the
%   support interval [Ai,Bi] and 0 elsewhere.
%
% EXAMPLE: s = 0:.1:10;
%          g = rectangl(s,[1 5]);
%          plotfs(s,'Rectangular Fuzzy Set')
%          plot(s,g)
%          hold off
%
% SEE ALSO: Bell, Bump, Shape, Trapzoid, Triangle

% Mark Beale 6-24-93
% Copyright (c) 1993 by PWS Publishing Company

[vr,vc] = size(v);
g = zeros(vr,length(s));

for i=1:vr
  a = v(i,1);
  b = v(i,2);

  g(i,:) = (s>=a) & (s<=b);
end
