function pendplot(x,u,t)
% PENDPLOT Plots pendulum and displays info.
%   This function is referred to in Chapter 5.
%
% PENDPLOT(X,U,T)
%   X - Current state of pendulum.
%   U - Force being applied to the pendulum base.
%   T - Time.
% Plots pendulum.
%
% The state X is = [base position;
%                   base velocity;
%                   pendulum angle;
%                   pendulum angular velocity]
%
% All angles are in radians.

% Mark Beale 6-24-93
% Copyright (c) 1993 by PWS Publishing Company

% CONSTANTS
L = 1;

% STATE
pos = x(1);
vel = x(2);
phi = x(3);

if (phi > pi/2), phi = pi/2, end
if (phi < -pi/2), phi = -pi/2, end

% PLOT BORDERS
%midx = round(pos/5)*5;
midx = 0;
minx = midx-5;
maxx = midx+5;

% PENDULUM END POINT
xp=sin(phi);
yp=cos(phi);

% PLOTTING
% ========

clg
hold off

axis([minx maxx 0 4])
hold on
plot([minx minx],[0 .5],'-r',[maxx maxx],[0 0.5],'-r')
plot([midx midx],[0 0.25],'-r',[minx maxx],[0.25 0.25],'-g');
plot([minx minx midx-2],[2 4 4],'--g',[maxx maxx midx+2],[2 4 4],'--g')
plot(0,0.25,'or')

plot([-1 1]+pos,[0 0]+.5,'-r');
plot([0 xp]*L+pos,[0 yp]*L+.5,'g');
title('Pendulum');
hold off

text(midx-4,3.0,'Position:');
text(midx-2,3.0,sprintf('%7.4g',pos));
text(midx+1,3.0,'Pos Vel:');
text(midx+3,3.0,sprintf('%7.4g',vel));

text(midx-4,2.5,'Angle');
text(midx-2,2.5,sprintf('%7.4g',phi));
text(midx+1,2.5,'Ang Vel:');
text(midx+3,2.5,sprintf('%7.4g',x(4)));

text(midx-4,2.0,'Force:');
text(midx-2,2.0,sprintf('%7.4g',u));
text(midx+1,2.0,'Time:');
text(midx+3,2.0,sprintf('%7.4g',t));

text(minx-.1,1,sprintf('%g',minx));
text(maxx-.1,1,sprintf('%g',maxx));
hold off
%set(gca,'box','off')
%set(gca,'xtick',[])
%set(gca,'ytick',[])
%set(gca,'xcolor',[0 0 0])
%set(gca,'ycolor',[0 0 0])
%drawnow

