% Stage 2 for Number Recognition Demonstration

% Copyright (c) 1993 by PWS Publishing Company

set(info_win,'vis','off');
set(info_str,'string','');
delete(han);

% DEFINE FUZZY SETS
% =================

% HORIZONTAL AXIS
xS = 0:24;
xL = eqshape(3,xS,5);
xG = shapeval(xL,xS);

% VERTICAL AXIS
yS = 0:36;
yL = eqshape(3,yS,7);
yG = shapeval(yL,yS);

% PLOT FUZZY SETS
% ===============

figure(f2);
plotfs2(xS,'Fuzzy Sets for Horizontal Axis', ...
  'Horizontal Coordinate')
plot(xS,xG)

figure(f3);
plotfs2(yS,'Fuzzy Sets for Vertical Axis', ...
  'Vertical Coordinate')
plot(yS,yG)

left=(scrnsz(3)-480)/2;
botm=(scrnsz(4)-80)/2;
set(info_win,'pos',[left,botm,480,80]);

str=['Now pick input points to specify the number you want the system to recognize. ',...
'The system will first normalize the range of your input data and then try to ',...
'recognize the normalized data as a number.'];

han=strformt(str,[80,480],info_win);
set(b(1),'vis','on');
set(b(2),'vis','off');
set(b(3),'string','Number','callback',...
         'set(f1,''pointer'',''crosshair'');clc;numdemoc','vis','on');
set(info_str(1),'string','Create a Number...?');
set(info_win,'vis','on');


