function y=hedge(x,h)
% HEDGE Applies a hedge to a fuzzy set.
%
% HEDGE(G,H)
%   G - Row vector(s) of grades.
%   H - Hedge value(s).
% Returns new row vector of grades.
%
% Hedge values greater than 1 make the fuzzy set more
%   constrictive. Values less than 1 make the set
%   more permissive (less constrictive).
%
% EXAMPLE: s = 0:.1:10;
%          g = near(s,5);
%          plotfs(s,'Hedges from 0.1 to 10.0 applied to "Near 5"')
%          plot(s,g);
%          for i=logspace(-1,1,10), plot(s,hedge(g,i),'g--'), end
%          hold off
%
% SEE ALSO: exactly, extremely, slightly, somewhat, vaguely, very 

% Mark Beale 6-24-93
% Copyright (c) 1993 by PWS Publishing Company

hl = length(h);

if hl == 1
  y = x.^h;
else
  [xr,xc] = size(x);
  y = zeros(xr,xc);
  for i=1:hl
    y(i,:) = x(i,:).^h(i);
  end
end
