/*
 * Copyright (c) 1992 The University of Utah and
 * the Center for Software Science (CSS).  All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the Center
 * for Software Science at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSS ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSS DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSS requests users of this software to return to css-dist@cs.utah.edu any
 * improvements that they make and grant CSS redistribution rights.
 *
 *      Utah $Hdr: tri_member.C 1.5 93/09/07$
 *      Author: Doug Orr, University of Utah CSS
 */

#include <iostream.h>
#include <stdio.h>
#include <math.h>
#include "tri_member.h"


/*  calc_area:  calculate the area of the "triangular" region */
static float calc_area (float lx, float mx, float rx,
			float h)
{

	float area = ((mx - lx) * h) / 2;

	area += ((rx - mx) * h) / 2;

	return area;
}



/* calc_centroid:  calculate the area of half the "triangle";
   find the x coordinate corresponding to that size */

static float calc_centroid (float a,		// area at centroid
			    float lx, float mx, float rx,
			    float h,
			    float s1, float b1,
			    float s2, float b2)
{
	float area = (h * (mx - lx)) / 2;
	if (a <= area) {
		/* figure out how far into the left triangle
		   we have to go to equal the desired area */
		
		/* (x*y)/2 = a
		   y = m*x + b; b = 0
		   x * (m*x) = 2*a
		   mx^2 - 2a = 0 ...  */

		return lx + sqrt ((2 * a) / s1);
	} else {
		a -= area;
		return rx - sqrt ((2 * a) / -s2);
	}
}


/*  template functions for particular domain types... */

float tri_member<int>::calc_area () const
{
	return ::calc_area (lx, mx, rx, h);
}

float tri_member<float>::calc_area () const
{
	return ::calc_area (lx, mx, rx, h);
}

float tri_member<int>::calc_centroid () const
{
	return ::calc_centroid (calc_area () / 2.0, lx, mx, rx, h, s1, b1, s2, b2);
}

float tri_member<float>::calc_centroid () const
{
	return ::calc_centroid (calc_area () / 2.0, lx, mx, rx, h, s1, b1, s2, b2);
}

geom_member<int> * 	
tri_member<int>::scale (const degree d) const
{
	return NULL;
}

geom_member<float> * 	
tri_member<float>::scale (const degree d) const
{
	return NULL;
}


geom_member<int> * 	
tri_member<int>::clip (const degree d) const
{
	return NULL;
}

geom_member<float> * 	
tri_member<float>::clip (const degree d) const
{
	return NULL;
}

int
tri_member<int>::output (const degree d) const
{
	return degree (0);
}

float
tri_member<float>::output (const degree d) const
{
	return degree (0);
}


degree tri_member<int>::is (const int value) const
{
	if (value < lx || value > rx)
		return degree (0);

	degree d =  (value <= mx)
		? degree (((s1 * value) + b1))
			:  degree (((s2 * value) + b2));

	return d;
}

degree tri_member<float>::is (const float value) const
{
	if (value < lx || value > rx)
		return degree (0);

	degree d =  (value <= mx)
		? degree (((s1 * value) + b1))
			:  degree (((s2 * value) + b2));

	return d;
}
