/*
 * Copyright (c) 1992 The University of Utah and
 * the Center for Software Science (CSS).  All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the Center
 * for Software Science at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSS ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSS DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSS requests users of this software to return to css-dist@cs.utah.edu any
 * improvements that they make and grant CSS redistribution rights.
 *
 *      Utah $Hdr$
 *      Author: Doug Orr, University of Utah CSS
 */

#ifndef _fam_surf_h
#define _fam_surf_h 1


#include "gen.h"
#include "fam.h"

template<class C> class fam_surf {
	int dim;
	geom_member<C> 	* * fns;

	fam<C>		* * surf;

    public:
	fam_surf (int dim_, ...);

	/* for the defined set of rules, apply inputs
	   to outputs */
	void 		apply (const fuzzy<C> &,
			       const fuzzy<C> &,
		               const fuzzy<C> &,
			       fuzzy<C> &);

	void		print_rules (const fuzzy<C> &,
				     const fuzzy<C> &,
				     const fuzzy<C> &,
				     const fuzzy<C> &);
};


template<class C>
void fam_surf<C>::print_rules (const fuzzy<C> & v1, 
			       const fuzzy<C> & v2,
			       const fuzzy<C> & v3,
			       const fuzzy<C> & result)
{

	for (int i=0; i<dim; i++) {
		if (surf [i]) {
			fam<C> * f = surf[i];
			for (fam_member<C> * m = f->rules (); m; m = m->next) {
				printf ("\tIF  %s IS %s  AND  %s IS %s  AND  %s IS %s  THEN  %s IS %s \n",
					v1.name (),
					fns [i]->name (),
					v2.name (),
					m->ir->name (),
					v3.name (),
					m->ic->name (),
					result.name (),
					m->r->name ());
			}
		}
	}
}


#endif /* _fam_surf_h */
