/* NEFCON-I: an interactive system for realization of a neural fuzzy controller

   Copyright (C) 1994 

   Institut fuer Betriebssysteme und Rechnerverbund, Technische Universitaet
   Braunschweig, Bueltenweg 74/75, 38106 Braunschweig, Germany, 
   hereby disclaims all copyright interests in the program NEFCON-I 
   written by Hermann-Josef Diekgerdes and Roland Stellmach.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/




#include "texte.h"

/*
 * Anmerkung :
 * Beim Hinzufuegen neuer Texte sollte darauf geachtet werden, dass diese
 * sowohl in Deutsch als auch in Englisch angegeben werden. Bei der Auswahl
 * von Texten mittels 'Txt(int)' werden die Array-Grenzen nicht kontrolliert,
 * d.h. bei zu grossen Nummern 'geht er baden'.
 */

char* deutsch[] = {
  /*000*/    "NEFCON-I"                                             ,
  /*001*/    "loeschen"                                             ,
  /*002*/    "setzen"                                               ,
  /*003*/    "neu"                                                  ,
  /*004*/    "Fuzzy-Sets"                                           ,
  /*005*/    "Fuzzy-Set-Name :"                                     ,
  /*006*/    "Linie von "                                           ,
  /*007*/    " nach "                                               ,
  /*008*/    "Fuzzy-Set '"                                          ,
  /*009*/    "' wurde gesichert"                                    ,
  /*010*/    "' wurde nicht gesichert"                              ,
  /*011*/    "Noch keine ling. Variable ausgewaehlt"                ,
  /*012*/    "' ausgewaehlt"                                        ,
  /*013*/    "Bei Ausgabevariablen nur monotone Fuzzysets erlaubt"  ,
  /*014*/    "Linie nicht im Definitionsbereich"                    ,
  /*015*/    "Fehlerhafte Eingabe des 2.ten Punktes"                ,
  /*016*/    "Fehlerhafte Eingabe des 1.ten Punktes"                ,
  /*017*/    "Noch kein Fuzzy-Set ausgewaehlt"                      ,
  /*018*/    "Auswahlmodus"                                         ,
  /*019*/    "Auswahlmodus beendet"                                 ,
  /*020*/    "' wurde geloescht"                                    ,
  /*021*/    "Fuzzy-Set nicht gefunden"                             ,
  /*022*/    "Eingabevariable"                                      ,
  /*023*/    "Ausgabevariable"                                      ,
  /*024*/    "Variablen"                                            ,
  /*025*/    "Linguist. Variable : "                                ,
  /*026*/    "Definitionsbereich : "                                ,
  /*027*/    "  bis : "                                             ,
  /*028*/    "Variablen - Typ : "                                   ,
  /*029*/    "Definitionsbereich ist zu klein"                      ,
  /*030*/    "Definitionsbereich ist zu klein fuer aktuelles Fuzzy-Set",
  /*031*/    "Fehlerhafte Angabe des Definitionsbereichs"           ,
  /*032*/    "Bei Ausgabevariablen nur monotone Fuzzysets erlaubt"  ,
  /*033*/    "Aktuelles Fuzzy-Set ist nicht monoton"                ,
  /*034*/    "Linguistische Variable '"                             ,
  /*035*/    "' ausgewaehlt"                                        ,
  /*036*/    "' wurde geloescht"                                    ,
  /*037*/    "Linguistische Variable nicht gefunden"                ,
  /*038*/    "' wurde gesichert"                                    ,
  /*039*/    "ende"                                                 ,
  /*040*/    "Meldungen"                                            ,
  /*041*/    "IF "                                                  ,
  /*042*/    " AND "                                                ,
  /*043*/    " THEN "                                               ,
  /*044*/    "Regeltafel"                                           ,
  /*045*/    "leer"                                                 ,
  /*046*/    "<"                                                    ,
  /*047*/    ">"                                                    ,
  /*048*/    "Regel-Eingabe"                                        ,
  /*049*/    "Bei leerer ling. Variablen wurde Fuzzy-Set angegeben" ,
  /*050*/    "Fuzzy-Set '"                                          ,
  /*051*/    "' nicht gefunden"                                     ,
  /*052*/    "kein Fuzzy-Set fuer '"                                ,
  /*053*/    "' angegeben"                                          ,
  /*054*/    "Ling. Variable '"                                     ,
  /*055*/    "Praemisse oder Konklusion duerfen nicht leer sein"    ,
  /*056*/    "Regel nicht gefunden"                                 ,
  /*057*/    "Regel wurde geloescht"                                ,
  /*058*/    "Neue Regel wurde gesichert"                           ,
  /*059*/    "Regeltabelle"                                         ,
  /*060*/    "loeschen"                                             ,
  /*061*/    "Syntax : "                                            ,
  /*062*/    "Regel : "                                             ,
  /*063*/    "ling. Var. Editor"                                    ,
  /*064*/    "Regel Editor"                                         ,
  /*065*/    "fertig"                                               ,
  /*066*/    "beenden"                                              ,
  /*067*/    "abbrechen"                                            ,
  /*068*/    "keine Eingabe-Variable definiert"                     ,
  /*069*/    "keine Ausgabe-Variable definiert"                     ,
  /*070*/    "kein Fuzzy-Set definiert fuer : "                     ,
  /*071*/    ""                                                     ,
  /*072*/    "keine ling. Variablen definiert"                      ,
  /*073*/    "Definition ling. Variablen"                           ,
  /*074*/    "Regel-Definition"                                     ,
  /*075*/    "NFC"                                                  ,
  /*076*/    "RgEd"                                                 ,
  /*077*/    "LvEd"                                                 ,
  /*078*/    "zuerst Editor fuer ling. Var. beenden"                ,
  /*079*/    "zuerst Regel-Editor beenden"                          ,
  /*080*/    "neue ling. Var. erstellt"                             ,
  /*081*/    "neue Regelbasis erstellt"                             ,
  /*082*/    "Da*/   tei"                                           ,
  /*083*/    "speichern der Steuer-Var."                            ,
  /*084*/    "speichern der Fehler-Var."                            ,
  /*085*/    "speichern der Steuer-Regeln"                          ,
  /*086*/    "speichern der Fehler-Regeln"                          ,
  /*087*/    "Ende"                                                 ,
  /*088*/    "Dateiname :"                                          ,
  /*089*/    "Ok"                                                   ,
  /*090*/    "Abbruch"                                              ,
  /*091*/    "ling. Variablen speichern"                            ,
  /*092*/    "ling. Variablen laden"                                ,
  /*093*/    "Regeln speichern"                                     ,
  /*094*/    "Regeln laden"                                         ,
  /*095*/    "Datei '"                                              ,
  /*096*/    "' konnte nicht geoeffnet werden"                      ,
  /*097*/    "Steuer-Variablen gespeichert"                         ,
  /*098*/    "Steuer-Variablen geladen"                             ,
  /*099*/    "Fehler beim Lesen der Datei : '"                      ,
  /*100*/    "'"                                                    ,
  /*101*/    "Steuer-Regeln gespeichert"                            ,
  /*102*/    "Steuer-Regeln geladen"                                ,
  /*103*/    "Anwendung"                                            ,
  /*104*/    "Anw"                                                  ,
  /*105*/    "Reihenfolge der Ein/Ausgabe-Variablen festlegen,"     ,
  /*106*/    "und Namen des zu steuernden Prg.'s angeben."          ,
  /*107*/    "Aufgabe :"                                            ,
  /*108*/    "Steuerwerte"                                          ,
  /*109*/    "Prozess"                                              ,
  /*110*/    "Messwerte"                                            ,
  /*111*/    ""                                                     ,
  /*112*/    "Kein Programm-Name angegeben"                         ,
  /*113*/    "Eine Eingabe-Variable ist doppelt"                    ,
  /*114*/    "Eine Ausgabe-Variable ist doppelt"                    ,
  /*115*/    "Neue Anwendung definiert"                             ,
  /*116*/    "sichern"                                              ,
  /*117*/    "Die Fehler-Variable ist keine Ausgabe-Variable"       ,
  /*118*/    ""                                                     ,
  /*119*/    "fehler"                                               ,
  /*120*/    "Keine Steuer-Variablen definiert"                     ,
  /*121*/    "Fehler-Regeln definieren"                             ,
  /*122*/    "Steuer-Var"                                           ,
  /*123*/    "Fehler-Var"                                           ,
  /*124*/    "Steuer-Regeln"                                        ,
  /*125*/    "Fehler-Regeln"                                        ,
  /*126*/    "definieren"                                           ,
  /*127*/    "starten"                                              ,
  /*128*/    "Es konnte kein Prozess gestartet werden"              ,
  /*129*/    "Programm nicht gefunden"                              ,
  /*130*/    "Programm laeuft bereits"                              ,
  /*131*/    "Es konnte keine 'Pipe' erzeugt werden"                ,
  /*132*/    "Regler-Oberflaeche"                                   ,
  /*133*/    "Regler"                                               ,
  /*134*/    "Regler"                                               ,
  /*135*/    "Oberflaeche"                                          ,
  /*136*/    "Start"                                                ,
  /*137*/    "Stop"                                                 ,
  /*138*/    "Ende"                                                 ,
  /*139*/    "Protokoll"                                            ,
  /*140*/    "Linguistische Variablen"                              ,
  /*141*/    "Regeln"                                               ,
  /*142*/    "Anwendung ist nicht korrekt definiert"                ,
  /*143*/    "speichern"                                            ,
  /*144*/    "laden"                                                ,
  /*145*/    "Steuer-Variablen"                                     ,
  /*146*/    "Fehler-Variablen"                                     ,
  /*147*/    "Steuer-Regeln"                                        ,
  /*148*/    "Fehler-Regeln"                                        ,
  /*149*/    "Keine Variable : ' "                                  ,
  /*150*/    "' definiert"                                          ,
  /*151*/    "Fehler-Var und Steuer-Var nicht kompatibel"           ,
  /*152*/    "Steuer-Regeln und Steuer-Var nicht kompatibel"        ,
  /*153*/    "Fehler-Regeln und Fehler-Var nicht kompatibel"        ,
  /*154*/    "Fehlerhaftes Fuzzy-Set in den Steuer-Var : "          ,
  /*155*/    "Fuer Eingabe-Var hoechstens '3-Ecke' erlaubt"         ,
  /*156*/    "Fuer Ausgabe-Var nur monotone Fuzzy-Sets erlaubt"     ,
  /*157*/    "Verbindung zum Prozess wurde unterbrochen"            ,
  /*158*/    "System-Werte"                                         ,
  /*159*/    "Info"                                                 ,
  /*160*/    "NEFCON-I Version 1.0, Juni 1994"  ,
  /*161*/    "(c) 1993, 1994 Technische Universitaet Braunschweig, Institut fuer Betriebssysteme und Rechnerverbund",
  /*162*/    "NEFCON-I wird OHNE JEGLICHE GARANTIE zur Verfuegung gestellt. Fuer Details lesen Sie bitte die Datei COPYING"        ,
  /*163*/    "NEFCON-Modell: Dr. Detlef Nauck"                      ,
  /*164*/    "Programmierung: Hermann-Josef Diekgerdes und Roland Stellmach"                                     ,
  /*165*/    "Regel-Darstellung"                                    ,
  /*166*/    "als Tabelle"                                          ,
  /*167*/    "als Tafel"                                            ,
  /*168*/    "gar nicht"                                            ,
  /*169*/    "FuzzySet-Darstellung"                                 ,
  /*170*/    "grafisch"                                             ,
  /*171*/    "Systemwerte-Darstellung"                              ,
  /*172*/    "numerisch"                                            ,
  /*173*/    "vorgegebene Regel-Basis benutzen"                     ,
  /*174*/    "Regel-Basis mit "                                     ,
  /*175*/    " Schritten erlernen"                                  ,
  /*176*/    "Fuzzy-Sets nicht optimieren"                          ,
  /*177*/    "Fuzzy-Sets mit Lernfaktor "                           ,
  /*178*/    " optimieren"                                          ,
  /*179*/    "Protokoll einfrieren"                                 ,
  /*180*/    "unzulaessiger Lern-Faktor"                            ,
  /*181*/    "Fehler-Variablen gespeichert"                         ,
  /*182*/    "Fehler-Regeln gespeichert"                            ,
  /*183*/    "Fehler-Variablen geladen"                             ,
  /*184*/    "Fehler-Regeln geladen"                                ,
  /*185*/    "Steuer-Variablen geloescht"                           ,
  /*186*/    "Fehler-Variablen geloescht"                           ,
  /*187*/    "Steuer-Regeln geloescht"                              ,
  /*188*/    "Fehler-Regeln geloescht"                              ,
  /*189*/    "Warnung :"                                            ,
  /*190*/    "Fehler :"                                             ,
  /*191*/    "Auto-Start"                                           ,
  /*192*/    "ja"                                                   ,
  /*193*/    "nein"                                                 ,
  /*194*/    "Regler gestartet"                                     ,
  /*195*/    "Regler gestoppt, Steuer-Variablen uebernommen"        ,
  /*196*/    "Regler laeuft bereits"                                ,
  /*197*/    " bzw. "                                               ,
  /*198*/    "falsche Angabe der Lersvhritte in Phase 1"            ,
  /*199*/    "falsche Angabe der Lersvhritte in Phase 2"            ,
  /*200*/    "Ausgaben"                                             ,
  /*201*/    "Winkel"                                               ,
  /*202*/    "Winkel-Geschwindigkeit"                               ,
  /*203*/    "Wagen-Position"                                       ,
  /*204*/    "Wagen-Geschwindigkeit"                                ,
  /*205*/    "Regeln werden geloescht : "                           ,
  /*206*/    " wenn sie "                                           ,
  /*207*/    " wenn sie insgesamt zu "                              ,
  /*208*/    " mal nacheinander nicht genutzt werden"               ,
  /*209*/    " Prozent ungenutzt bleiben"                           ,
  /*210*/    "Eine Regel gilt als ungenutzt <=> Treffergrad <= "    ,
  /*211*/    "Regel-Lern-Optionen"                                  ,
  /*212*/    "Regel-Lern-Optionen"                                  ,
  /*213*/    "RgLrnOpt"                                             ,
  /*214*/    "Protokoll-Datei erstellen"                            ,
  /*215*/    "Regel-Ziel nicht erfuellt"                            ,
  /*216*/    "Protokoll-Datei konnte nicht geoeffnet werden"        ,
  /*217*/    "Start des Reglers mit Lern-Faktor : "                 ,
  /*218*/    "linguistische Variablen :"                            ,
  /*219*/    "Beendigung des Reglers nach "                         ,
  /*220*/    " Schritten"                                           ,
  /*221*/    "in den Steuer-Variablen "                             ,
  /*222*/    "in den Fehler-Variablen "                             ,
  /*223*/    "zuerst Regler-Oberflaeche schliessen"                 ,
  /*224*/    "Eine Zustandsaenderung um "                           ,
  /*225*/    " Prozent - plus/minus "                               ,
  /*226*/    " - gilt als gut"                                      ,
  /*227*/    "Fuzzy-Sets beim Lernen optimieren"                    ,
  /*228*/    "Intervallbreite : min. "                              ,
  /*229*/    " max. "                                               ,
  /*230*/    "Fehlerhafte Definition der Breite"                    ,
  /*231*/    "zuerst Anwendungsprogramm beenden"                    ,
  /*232*/    "Aenderungen ignoriert; Programm laeuft schon"
};

char* english[] = {
  /*000*/    "NEFCON-I"                                             ,
  /*001*/    "delete"                                               ,
  /*002*/    "ok"                                                   ,
  /*003*/    "new"                                                  ,
  /*004*/    "fuzzy sets"                                           ,
  /*005*/    "name of fuzzy set :"                                  ,
  /*006*/    "line from "                                           ,
  /*007*/    " to "                                                 ,
  /*008*/    "fuzzy set '"                                          ,
  /*009*/    "' is saved"                                           ,
  /*010*/    "' is not saved"                                       ,
  /*011*/    "no ling. variable selected"                           ,
  /*012*/    "' is selected"                                        ,
  /*013*/    "only monoton fuzzy sets allowed for output-variable"  ,
  /*014*/    "line is not in area"                                  ,
  /*015*/    "wrong definition of the 2nd point"                    ,
  /*016*/    "wrong definition of the 1st point"                    ,
  /*017*/    "there is no fuzzy set selected"                       ,
  /*018*/    "start of select mode"                                 ,
  /*019*/    "end of select-mode"                                   ,
  /*020*/    " ' is deleted"                                        ,
  /*021*/    "fuzzy set not found"                                  ,
  /*022*/    "input-variable"                                       ,
  /*023*/    "output-variable"                                      ,
  /*024*/    "variables"                                            ,
  /*025*/    "variable name : "                                     ,
  /*026*/    "range of definition : "                               ,
  /*027*/    " to : "                                               ,
  /*028*/    "variable typ : "                                      ,
  /*029*/    "area is to small"                                     ,
  /*030*/    "area is to small for actual fuzzy set"                ,
  /*031*/    "error in definition of new area"                      ,
  /*032*/    "only monoton fuzzy sets allowed for output-variable"  ,
  /*033*/    "actual fuzzy set is not monoton"                      ,
  /*034*/    "linguistic variable '"                                ,
  /*035*/    "' is selected"                                        ,
  /*036*/    "' is deleted"                                         ,
  /*037*/    "linguistic variable not found"                        ,
  /*038*/    "' is saved"                                           ,
  /*039*/    "end"                                                  ,
  /*040*/    "messages"                                             ,
  /*041*/    "IF "                                                  ,
  /*042*/    " AND "                                                ,
  /*043*/    " THEN "                                               ,
  /*044*/    "rule board"                                           ,
  /*045*/    "empty"                                                ,
  /*046*/    "<"                                                    ,
  /*047*/    ">"                                                    ,
  /*048*/    "rule definition"                                      ,
  /*049*/    "fuzzy set specified for empty variable"               ,
  /*050*/    "fuzzy set '"                                          ,
  /*051*/    "' not found"                                          ,
  /*052*/    "no fuzzy set for '"                                   ,
  /*053*/    "' specified"                                          ,
  /*054*/    "linguistic variable '"                                ,
  /*055*/    "antecedent or konklusion is empty"                    ,
  /*056*/    "fuzzy rule not found"                                 ,
  /*057*/    "fuzzy rule deleted"                                   ,
  /*058*/    "new fuzzy rule saved"                                 ,
  /*059*/    "rule table"                                           ,
  /*060*/    "delete"                                               ,
  /*061*/    "syntax :"                                             ,
  /*062*/    "rule :"                                               ,
  /*063*/    "ling. var. editor"                                    ,
  /*064*/    "fuzzy rule editor"                                    ,
  /*065*/    "done"                                                 ,
  /*066*/    "exit"                                                 ,
  /*067*/    "quit"                                                 ,
  /*068*/    "no input-variable defined"                            ,
  /*069*/    "no output-variable defined"                           ,
  /*070*/    "no fuzzy set for '"                                   ,
  /*071*/    "' defined"                                            ,
  /*072*/    "no linguistic variable defined"                       ,
  /*073*/    "definition of linguistic variables"                   ,
  /*074*/    "fuzzy rule definition"                                ,
  /*075*/    "NFC"                                                  ,
  /*076*/    "RlEd"                                                 ,
  /*077*/    "LvEd"                                                 ,
  /*078*/    "first finish the ling. var. editor"                   ,
  /*079*/    "first finish the rule editor"                         ,
  /*080*/    "new linguistic variable created"                      ,
  /*081*/    "new fuzzy rule base created"                          ,
  /*082*/    "file"                                                 ,
  /*083*/    "save control var"                                     ,
  /*084*/    "save error var"                                       ,
  /*085*/    "save control rules"                                   ,
  /*086*/    "save error rules"                                     ,
  /*087*/    "end"                                                  ,
  /*088*/    "filename"                                             ,
  /*089*/    "ok"                                                   ,
  /*090*/    "quit"                                                 ,
  /*091*/    "save linguistic variables"                            ,
  /*092*/    "load linguistic variables"                            ,
  /*093*/    "save fuzzy rules"                                     ,
  /*094*/    "load fuzzy rules"                                     ,
  /*095*/    "cannot open file '"                                   ,
  /*096*/    "'"                                                    ,
  /*097*/    "control variables are saved"                          ,
  /*098*/    "control variables are loaded"                         ,
  /*099*/    "read error in file '"                                 ,
  /*100*/    "'"                                                    ,
  /*101*/    "control rules saved"                                  ,
  /*102*/    "control rules loaded"                                 ,
  /*103*/    "application"                                          ,
  /*104*/    "App"                                                  ,
  /*105*/    "define the order of the in/output-variables"          ,
  /*106*/    "and the name of the application-program"              ,
  /*107*/    "task :"                                               ,
  /*108*/    "input"                                                ,
  /*109*/    "process"                                              ,
  /*110*/    "output"                                               ,
  /*111*/    ""                                                     ,
  /*112*/    "no name specified"                                    ,
  /*113*/    "one input-variable defined twice"                     ,
  /*114*/    "one output-variable defined twice"                    ,
  /*115*/    "new application defined"                              ,
  /*116*/    "save"                                                 ,
  /*117*/    "wrong type of the error-variable"                     ,
  /*118*/     ""                                                    ,
  /*119*/    "error"                                                ,
  /*120*/    "no control variable defined"                          ,
  /*121*/    "define error rules"                                   ,
  /*122*/    "control var"                                          ,
  /*123*/    "error var"                                            ,
  /*124*/    "control rules"                                        ,
  /*125*/    "error rules"                                          ,
  /*126*/    "define"                                               ,
  /*127*/    "start"                                                ,
  /*128*/    "could not start process"                              ,
  /*129*/    "program not found"                                    ,
  /*130*/    "program is in execution"                              ,
  /*131*/    "could not create pipe"                                ,
  /*132*/    "controller"                                           ,
  /*133*/    "ctrl"                                                 ,
  /*134*/    "controller"                                           ,
  /*135*/    "surface"                                              ,
  /*136*/    "start"                                                ,
  /*137*/    "stop"                                                 ,
  /*138*/    "end"                                                  ,
  /*139*/    "protocol"                                             ,
  /*140*/    "linguistic variables"                                 ,
  /*141*/    "rules"                                                ,
  /*142*/    "badly defined application"                            ,
  /*143*/    "save"                                                 ,
  /*144*/    "load"                                                 ,
  /*145*/    "control var"                                          ,
  /*146*/    "error var"                                            ,
  /*147*/    "control rules"                                        ,
  /*148*/    "error rules"                                          ,
  /*149*/    "variable '"                                           ,
  /*150*/    "' not found"                                          ,
  /*151*/    "control var. and error var. not compatible"           ,
  /*152*/    "control rules and control var not compatible"         ,
  /*153*/    "control rules and error rules not compatible"         ,
  /*154*/    "incorrect fuzzy set in control var. : "               ,
  /*155*/    "at most 2 lines allowed for fuzzy sets in antecedent" ,
  /*156*/    "only monoton fuzzy sets in konklusion"                ,
  /*157*/    "comunication error"                                   ,
  /*158*/    "system values"                                        ,
  /*159*/    "info"                                                 ,
  /*160*/    "NEFCON-I version 1.0, June 1994"  ,
  /*161*/    "(c) 1993, 1994 Technical University of Braunschweig, Department of Computer Science",
  /*162*/    "NEFCON-I comes with ABSOLUTELY NO WARRANTY; for details see the file COPYING",
  /*163*/    "NEFCON model by Dr. Detlef Nauck"                     ,
  /*164*/    "Programming by Hermann-Josef Diekgerdes and Roland Stellmach"                                      ,
  /*165*/    "rule representation"                                  ,
  /*166*/    "as table"                                             ,
  /*167*/    "as board"                                             ,
  /*168*/    "none"                                                 ,
  /*169*/    "fuzzy set representation"                             ,
  /*170*/    "graphical"                                            ,
  /*171*/    "system value representation"                          ,
  /*172*/    "numerical"                                            ,
  /*173*/    "use given control rules"                              ,
  /*174*/    "learn rule base with "                                ,
  /*175*/    " steps"                                               ,
  /*176*/    "no optimization of fuzzy sets"                        ,
  /*177*/    "optimize fuzzy sets with factor "                     ,
  /*178*/    " "                                                    ,
  /*179*/    "freeze protocol"                                      ,
  /*180*/    "wrong factor"                                         ,
  /*181*/    "error varables saved"                                 ,
  /*182*/    "error rules saved"                                    ,
  /*183*/    "error variables are loaded"                           ,
  /*184*/    "error rules are loaded"                               ,
  /*185*/    "control variables deleted"                            ,
  /*186*/    "error varables deleted"                               ,
  /*187*/    "control rules deleted"                                ,
  /*188*/    "error rules deleted"                                  ,
  /*189*/    "warning :"                                            ,
  /*190*/    "error :"                                              ,
  /*191*/    "Auto-Start"                                           ,
  /*192*/    "yes"                                                  ,
  /*193*/    "no"                                                   ,
  /*194*/    "controller started"                                   ,
  /*195*/    "controller stopped, took over control variables"      ,
  /*196*/    "controller is already running"                        ,
  /*197*/    " and "                                                ,
  /*198*/    "illegal number of learning steps"                     ,
  /*199*/    "illegal number of learning steps"                     ,
  /*200*/    "output"                                               ,
  /*201*/    "angel"                                                ,
  /*202*/    "angel velocity"                                       ,
  /*203*/    "cart position"                                        ,
  /*204*/    "cart velocity"                                        ,
  /*205*/    "rules will be deleted : "                              ,
  /*206*/    "- if they are not used for "                           ,
  /*207*/    "- if they are not used in "                          ,
  /*208*/    " steps"                                               ,
  /*209*/    " percent of all cases"                                ,
  /*210*/    "a rule is considered unused  <=> hit degree <= "      ,
  /*211*/    "rule learning options"                                ,
  /*212*/    "rule learning options"                                ,
  /*213*/    "RlLrnOpt"                                             ,
  /*214*/    "create a protocol file"                               ,
  /*215*/    "target of control not reached"                        ,
  /*215*/    "can't open file for protocol"                         ,
  /*217*/    "start of the controller with learning factor :"       ,
  /*218*/    "linguistic Variables :"                               ,
  /*219*/    "termination of the controller after "                 ,
  /*220*/    " steps"                                               ,
  /*221*/    "in the control variables "                            ,
  /*222*/    "in the error variables "                              ,
  /*223*/    "first close controller window"                        ,
  /*224*/    "a status-change of "                                  ,
  /*225*/    " percent - plus/minus "                               ,
  /*226*/    " - is defined as good"                                ,
  /*227*/    "optimize fuzzy sets while learning"                   ,
  /*228*/    "interval width : min. "                               ,
  /*229*/    " max. "                                               ,
  /*230*/    "wrong definition of the width"                        ,
  /*231*/    "first quit the application program"                   ,
  /*232*/    "changes ignored; program already is running"
};

// falls kein init_texte_.. aufgerufen wird : deutsche Texte
char** text_array = deutsch;

void init_texte_deutsch() { text_array = deutsch; }

void init_texte_englisch() { text_array = english; }
