/* NEFCON-I: an interactive system for realization of a neural fuzzy controller

   Copyright (C) 1994 

   Institut fuer Betriebssysteme und Rechnerverbund, Technische Universitaet
   Braunschweig, Bueltenweg 74/75, 38106 Braunschweig, Germany, 
   hereby disclaims all copyright interests in the program NEFCON-I 
   written by Hermann-Josef Diekgerdes and Roland Stellmach.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/




#ifndef regel_tab_h
#define regel_tab_h

#include <InterViews/monoglyph.h>

#include "lingvar.h"
#include "regel.h"
#include "nfclook.h"
#include "regel_tafel.h"


/*
 *------------------------------------------------------------------------------
 * Klasse : RegelTabMaske
 * Zweck  : Erstellt ein Menue, mit dem man fuer jede ling. Variable ein
 *          Fuzzy-Set auswaehlen kann. Diese Belegung der ling. Variablen
 *          dient als Maske fuer Regeln, die in der Tabelle dargestellt werden
 *          sollen.
 *------------------------------------------------------------------------------
 */
class RegelTabMaske
{
  public : RegelTabMaske(const LingVarSatz*);
           virtual ~RegelTabMaske();
           virtual void neue_maske() {};
           Regel* maske() const;
           void setz_maske(LingVar*, int fuzzyset_nr);
           Glyph* masken_glyph();
  private: void _callback();
           void _mach_menue_balken(LingVarTyp, int nr);
           Glyph* _glyph;
           MenuItem* _mach_menue(Action*, LingVar*);
           const LingVarSatz* _lingvarsatz;
           Regel* _maske;
           Menu* _menue_balken;
           int _lingvar_auswahl, _fuzzyset_auswahl;
};


/*
 *------------------------------------------------------------------------------
 * Klasse : RegelTabelle
 * Zweck  : Stellt die RegelBasis in Form einer Tabelle dar. Die linguistischen
 *          Variablen, die in der x/y-Leiste der Tabelle dargestellt werden,
 *          sind frei waehlbar. Bei mehr als 2 Eingabe-Variablen bzw, mehr als
 *          einer Ausgabe-Variablen, koennen die nicht dargestellten ling.
 *          Variablen vorbelegt werden (siehe RegelTabMaske).
 *------------------------------------------------------------------------------
 */
class Tabelle;

class RegelTabelle : public RegelBrowser, public RegelTabMaske
{
  public : RegelTabelle(const RegelBasis*, const LingVarSatz*);
           virtual void zeig_regeln(const RegelBasis*);
           void zeig_regel(Regel*);
           virtual void markiere(int nr);
           virtual int markiert();
           virtual Glyph* glyph();
           virtual void neue_maske();
           LingVar* konklusion();
           Tabelle* tabelle();
           const LingVarSatz* lingvarsatz();
           boolean maskiere(Regel*, boolean komplett);
  private: void _move_callback();
           void _press_callback();
           void _x_leiste_cb();
           void _y_leiste_cb();
           void _neue_leiste(DimensionName);
           void _neue_konklusion();
           Glyph* _glyph;
           Menu* _mach_menue();
           boolean _hol_tab_koo(Regel*, int& spalte, int& zeile);
           Tabelle* _tabelle;
           int _max_fuzzysets;
           const RegelBasis* _regelbasis;
           const LingVarSatz* _lingvarsatz;
           CopyString _x_leiste,                 // Namen der ling. Variablen
                      _y_leiste;                 // in X/Y-Leiste der Tabelle
           AuswahlButton *_x_leiste_auswahl,
                         *_y_leiste_auswahl;
           int _menue_auswahl;
};

inline Tabelle* RegelTabelle::tabelle() { return _tabelle; }

inline const LingVarSatz* RegelTabelle::lingvarsatz() { return _lingvarsatz; }

inline void RegelTabelle::_x_leiste_cb() { _neue_leiste(Dimension_X); }

inline void RegelTabelle::_y_leiste_cb() { _neue_leiste(Dimension_Y); }


/*
 *------------------------------------------------------------------------------
 * Klasse : GrafRegelEd
 * Zweck  : Aufbauend auf die RegelTabelle koennen mit dem GrafRegelEd Regeln
 *          eingegeben werden. Dies geschieht per Menue in den einzelnen
 *          Tabellen-Feldern.
 *------------------------------------------------------------------------------
 */
class GrafRegelEd : public RegelTabelle
{
  public : GrafRegelEd(NfcAusgabe*, RegelBasis*, LingVarSatz*);
           virtual void markiere(int regel_nr);
           NfcAusgabe* ausgabe_feld;
  private: boolean _parse_regel(Regel&, const LingVarSatz*);
           void _callback();
           RegelBasis* _regelbasis;
           Action* _cb_ptr;
           MenuItem* _mach_menue(LingVar*);
           Menu* _menue_balken;
           LingVar* _konklusion;
           int _akt_regel,
               _menue_auswahl;
};

#endif
