/* NEFCON-I: an interactive system for realization of a neural fuzzy controller

   Copyright (C) 1994 

   Institut fuer Betriebssysteme und Rechnerverbund, Technische Universitaet
   Braunschweig, Bueltenweg 74/75, 38106 Braunschweig, Germany, 
   hereby disclaims all copyright interests in the program NEFCON-I 
   written by Hermann-Josef Diekgerdes and Roland Stellmach.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/




#ifndef protokoll_ed_h
#define protokoll_ed_h

#include <IV-look/dialogs.h>
#include <InterViews/action.h>

/*
 *------------------------------------------------------------------------------
 * Struktur : ProtokollStruktur
 * Zweck  : Definiert, was in einem Protokoll stehen soll.
 *------------------------------------------------------------------------------
 */

enum RegelRep   { alsTafel, alsTabelle, keineRegeln };
enum LingVarRep { alsGrafik, keineLinVar };
enum WerteRep   { Numerisch , Grafisch, Garnisch };

struct ProtokollStruktur
{
  ProtokollStruktur();
  int regel_rep;
  int lingvar_rep;
  int werte_rep;
  boolean mit_prot_datei;
};


/*
 *------------------------------------------------------------------------------
 * Klasse : ProtokollEd
 * Zweck  : Oeffnet ein Popup-Window, mit dessen Hilfe eine ProtokollStruktur
 *          erstellt bzw. initialisiert wird.
 *------------------------------------------------------------------------------
 */

class ProtokollEd : public Dialog
{
  public : ProtokollEd(Style*, Action* ok_cb, Action* nook_cb);
           ~ProtokollEd();
           ProtokollStruktur* prot_struktur();
           void einblenden(Window*, ProtokollStruktur*);

  // lokale Funktionen
  private: void _ende();
           void _abbruch();
           void _init(ProtokollStruktur*);

  // Zustandsvariablen
  private: ProtokollStruktur _neue_strukt;

  // Grafikelemente
  private: Action *_ok_cb, *_nook_cb;
           Button *_rg_bt1, *_rg_bt2, *_rg_bt3,
                  *_lv_bt1, *_lv_bt2,
                  *_sw_bt1, *_sw_bt2, *_sw_bt3,
                  *_dat_bt;
};

#endif
