/* NEFCON-I: an interactive system for realization of a neural fuzzy controller

   Copyright (C) 1994 

   Institut fuer Betriebssysteme und Rechnerverbund, Technische Universitaet
   Braunschweig, Bueltenweg 74/75, 38106 Braunschweig, Germany, 
   hereby disclaims all copyright interests in the program NEFCON-I 
   written by Hermann-Josef Diekgerdes and Roland Stellmach.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/




#include <IV-look/telltale.h>
#include <IV-look/kit.h>
#include <InterViews/background.h>
#include <InterViews/layout.h>

#include "texte.h"
#include "nfclook.h"
#include "protokoll_ed.h"

declareActionCallback(ProtokollEd);
implementActionCallback(ProtokollEd);

/*
 *------------------------------------------------------------------------------
 *---------------- Definition der Struktur : ProtokollStruktur -----------------
 *------------------------------------------------------------------------------
 */

ProtokollStruktur::ProtokollStruktur()
{
  regel_rep      = alsTabelle;
  lingvar_rep    = alsGrafik;
  werte_rep      = Grafisch;
  mit_prot_datei = false;
}

/*
 *------------------------------------------------------------------------------
 *-------------------- Definition der Klasse : ProtokollEd ---------------------
 *------------------------------------------------------------------------------
 */

ProtokollEd::ProtokollEd(Style* style, Action* ok_cb, Action* nook_cb)
  : Dialog(nil, style)
{
  TelltaleGroup* group;

  _ok_cb   = ok_cb;
  _nook_cb = nook_cb;
  if(_ok_cb != nil)
    Resource::ref(_ok_cb);
  if(_nook_cb != nil)
    Resource::ref(_nook_cb);

  Coord rand      = 10;
  LayoutKit* lkit = LayoutKit::instance();
  WidgetKit* wkit = WidgetKit::instance();
  NfcKit* nkit    = NfcKit::instance();

  wkit->begin_style("NfcInfoStyle","NfcInfoFont");

  // Buttons zur Auswahl der Regeldarstellung
  group = new TelltaleGroup();
  _rg_bt1 = wkit->radio_button(
              group,
              Txt(167),
              new NfcAction(&_neue_strukt.regel_rep, alsTafel, nil)
            );
  _rg_bt2 = wkit->radio_button(
              group,
              Txt(166),
              new NfcAction(&_neue_strukt.regel_rep, alsTabelle, nil)
            );
  _rg_bt3 = wkit->radio_button(
              group,
              Txt(168),
              new NfcAction(&_neue_strukt.regel_rep, keineRegeln, nil)
            );
  Glyph* regel_rep = lkit->hbox(
                       _rg_bt1, lkit->hglue(rand, 0, 0),
                       _rg_bt2, lkit->hglue(rand, 0, 0),
                       _rg_bt3, lkit->hglue(0, fil, 0)
                     );


  // Buttons zur Auswahl der ling. Var. - Darstellung
  group = new TelltaleGroup();
  _lv_bt1 = wkit->radio_button(
              group,
              Txt(170),
              new NfcAction(&_neue_strukt.lingvar_rep, alsGrafik, nil)
            );
  _lv_bt2 = wkit->radio_button(
              group,
              Txt(168),
              new NfcAction(&_neue_strukt.lingvar_rep, keineLinVar, nil)
            );
  Glyph* lingvar_rep = lkit->hbox(
                         _lv_bt1, lkit->hglue(rand, 0, 0),
                         _lv_bt2, lkit->hglue(0, fil, 0)
                       );

  // Buttons zur Auswahl der Systemwertedarstellung
  group = new TelltaleGroup();
  _sw_bt1 = wkit->radio_button(
              group,
              Txt(170),
              new NfcAction(&_neue_strukt.werte_rep, Grafisch, nil)
            );
  _sw_bt2 = wkit->radio_button(
              group,
              Txt(172),
              new NfcAction(&_neue_strukt.werte_rep, Numerisch, nil)
            );
  _sw_bt3 = wkit->radio_button(
              group,
              Txt(168),
              new NfcAction(&_neue_strukt.werte_rep, Garnisch, nil)
            );
  Glyph* werte_rep = lkit->hbox(
                       _sw_bt1, lkit->hglue(rand, 0, 0),
                       _sw_bt2, lkit->hglue(rand, 0, 0),
                       _sw_bt3, lkit->hglue(0, fil, 0)
                     );

  // Button fuer Datei-Protokoll
  _dat_bt = wkit->check_box(Txt(214), nil);

  // Button fuer Ende und Abbruch definieren
  Action* cb  = new ActionCallback(ProtokollEd)(this,&ProtokollEd::_ende);
  Button* bt1 = wkit->push_button(Txt(87), cb);
  cb          = new ActionCallback(ProtokollEd)(this,&ProtokollEd::_abbruch);
  Button* bt2 = wkit->push_button(Txt(90), cb);

  wkit->end_style();

  _init(&_neue_strukt);

  body(
    new Background(
      lkit->margin(
        lkit->vbox(
          nkit->text_drauf(Txt(165), regel_rep, false),
          lkit->vglue(rand, 0, 0),
          nkit->text_drauf(Txt(169), lingvar_rep, false),
          lkit->vglue(rand, 0, 0),
          nkit->text_drauf(Txt(171), werte_rep, false),
          lkit->vglue(rand, 0, 0),
          lkit->hbox(_dat_bt, lkit->hglue()),
          lkit->vglue(rand, 0, 0),
          lkit->hbox(bt1, lkit->hglue(), bt2)
        ), rand, rand
      ), wkit->background()
    )
  );
}


ProtokollEd::~ProtokollEd()
{
  if(_ok_cb != nil)
    Resource::unref(_ok_cb);
  if(_nook_cb != nil)
    Resource::unref(_nook_cb);
}


/*
 *------------------------------------------------------------------------------
 * Elementfunktion : ProtokollEd::prot_struktur()
 * Rueckgabewert : liefert neu definierte ProtokollStruktur.
 * Zweck : siehe Rueckgabewert.
 *------------------------------------------------------------------------------
 */
ProtokollStruktur* ProtokollEd::prot_struktur() { return &_neue_strukt; }


/*
 *------------------------------------------------------------------------------
 * Elementfunktion : ProtokollEd::einblenden(Window, ProtokollStruktur*)
 * Parameter : Window*            - Elternfenster
 *             ProtokollStruktur* - Default Struktur.
 * Zweck : Der Protokoll-Editor (bzw. das Popup-Window) wird eingeblendet.
 *------------------------------------------------------------------------------
 */
void ProtokollEd::einblenden(Window* fenster, ProtokollStruktur* def)
{
  if(def != nil)
    _neue_strukt = *def;
  _init(&_neue_strukt);
  post_for(fenster);
}


/*
 *------------------------------ lokale Funktionen -----------------------------
 */

void ProtokollEd::_ende()
{
  dismiss(true);
  _neue_strukt.mit_prot_datei = _dat_bt->state()->test(
                                   TelltaleState::is_chosen
                                );
  if(_ok_cb != nil)
    _ok_cb->execute();
}

void ProtokollEd::_abbruch()
{
  dismiss(false);
  if(_nook_cb != nil)
    _nook_cb->execute();
}

void ProtokollEd::_init(ProtokollStruktur* struktur)
{
  switch(struktur->regel_rep) {           // Default-Einstellung
    case alsTafel    : _rg_bt1->state()->set(TelltaleState::is_chosen, true);
      break;
    case alsTabelle  : _rg_bt2->state()->set(TelltaleState::is_chosen, true);
      break;
    case keineRegeln : _rg_bt3->state()->set(TelltaleState::is_chosen, true);
      break;
    default : break;
  }
  switch(struktur->werte_rep) {           // Default-Einstellung
    case Grafisch  : _sw_bt1->state()->set(TelltaleState::is_chosen, true);
      break;
    case Numerisch : _sw_bt2->state()->set(TelltaleState::is_chosen, true);
      break;
    case Garnisch  : _sw_bt3->state()->set(TelltaleState::is_chosen, true);
      break;
    default : break;
  }
  switch(struktur->lingvar_rep) {         // Default-Einstellung
    case alsGrafik   : _lv_bt1->state()->set(TelltaleState::is_chosen, true);
      break;
    case keineLinVar : _lv_bt2->state()->set(TelltaleState::is_chosen, true);
      break;
    default : break;
  }
  if(struktur->mit_prot_datei)
    _dat_bt->state()->set(TelltaleState::is_chosen, true);
  else
    _dat_bt->state()->set(TelltaleState::is_chosen, false);
}
