/* NEFCON-I: an interactive system for realization of a neural fuzzy controller

   Copyright (C) 1994 

   Institut fuer Betriebssysteme und Rechnerverbund, Technische Universitaet
   Braunschweig, Bueltenweg 74/75, 38106 Braunschweig, Germany, 
   hereby disclaims all copyright interests in the program NEFCON-I 
   written by Hermann-Josef Diekgerdes and Roland Stellmach.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/




/*
 * Hauptprogramm zum Aufruf des neuronalen Fuzzy-Controllers
 * (C) 1994 Inst. f. Betriebssysteme und Rechnerverbund, TU Braunschweig
 */

#include <IV-look/kit.h>
#include <InterViews/background.h>
#include <InterViews/session.h>
#include <InterViews/style.h>
#include <InterViews/font.h>
#include <InterViews/window.h>
#include <InterViews/display.h>
#include <InterViews/layout.h>

#include "texte.h"
#include "nfc_ed.h"

static PropertyData props[] = {
    { "*FieldEditor*background",                     "#90ffa0" },
    { "*Markierung",                                 "#000000" },
    { "*cursorFlashRate",                                  "0" },
    { "*PushButton*font",          "*times-bold-r-normal--12*" },
    { "*NfcEditorFont*font", "*helvetica-medium-r-normal--12*" },
    { "*NfcInfoFont*font",     "*helvetica-bold-r-normal--12*" },
    { "*DataDirectory",                                "data/" },
    { "*protocol",                              "protocol.nfc" },
    { "*english",                                        "off" },
    { nil }
};

static OptionDesc options[] = {
    { "-editorfont=", "*NfcEditorFont*font", OptionValueAfter          },
    { "-infofont=",   "*NfcInfoFont*font",   OptionValueAfter          },
    { "-dir=",        "*DataDirectory",      OptionValueAfter          },
    { "-p=",          "*protocol",           OptionValueAfter          },
    { "-e",           "*english",            OptionValueImplicit, "on" },
    { nil }
};

int main(int argc, char** argv)
{
  Session* session = new Session("nfc", argc, argv, options, props);
  WidgetKit* kit   = WidgetKit::instance();
  Style* style     = kit->style();

  // Setzen der Sprache
  if(style->value_is_on("english"))
    init_texte_englisch();
  else
    init_texte_deutsch();

  style->attribute("name", Txt(0));
  style->attribute("iconName", Txt(75));

  session->run_window(
    new ApplicationWindow( new Background(new NfcEditor(), kit->background()))
  );
}
