/* NEFCON-I: an interactive system for realization of a neural fuzzy controller

   Copyright (C) 1994 

   Institut fuer Betriebssysteme und Rechnerverbund, Technische Universitaet
   Braunschweig, Bueltenweg 74/75, 38106 Braunschweig, Germany, 
   hereby disclaims all copyright interests in the program NEFCON-I 
   written by Hermann-Josef Diekgerdes and Roland Stellmach.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/




#ifndef lern_ed_h
#define lern_ed_h

#include <IV-look/dialogs.h>
#include <InterViews/action.h>

#include "controller.h"
#include "nfclook.h"

/*
 *------------------------------------------------------------------------------
 * Klasse : LernEd
 * Zweck  : Oeffnet ein Popup-Window, mit dessen Hilfe eine RgLernStruktur
 *          erstellt bzw. initialisiert wird.
 *------------------------------------------------------------------------------
 */
class LernEd : public Dialog
{
  public : LernEd(Style*);
           RgLernStruktur* lern_struktur();
           boolean einblenden(Window*, RgLernStruktur*);

  // lokale Funktionen
  private: void _ende();
           void _abbruch();
           void _init(RgLernStruktur*);

  // Zustandsvariablen
  private: RgLernStruktur _neue_strukt;

  // Grafikelemente
  private: Button *_prozent_bt,
                  *_dauer_bt,
                  *_fuz_opt_bt;
           EingabeFeld *_prozent_ed,
                       *_dauer_ed,
                       *_min_treffer_ed;
};

#endif
