/* NEFCON-I: an interactive system for realization of a neural fuzzy controller

   Copyright (C) 1994 

   Institut fuer Betriebssysteme und Rechnerverbund, Technische Universitaet
   Braunschweig, Bueltenweg 74/75, 38106 Braunschweig, Germany, 
   hereby disclaims all copyright interests in the program NEFCON-I 
   written by Hermann-Josef Diekgerdes and Roland Stellmach.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/




#include <IV-look/telltale.h>
#include <IV-look/kit.h>
#include <InterViews/action.h>
#include <InterViews/background.h>

#include <InterViews/layout.h>

#include "texte.h"
#include "nfclook.h"
#include "lern_ed.h"

declareActionCallback(LernEd);
implementActionCallback(LernEd);

/*
 *------------------------------------------------------------------------------
 *---------------------- Definition der Klasse : LernEd ------------------------
 *------------------------------------------------------------------------------
 */

LernEd::LernEd(Style* style)
  : Dialog(nil, style)
{
  Coord rand      = 10;
  LayoutKit* lkit = LayoutKit::instance();
  WidgetKit* wkit = WidgetKit::instance();
  NfcKit* nkit    = NfcKit::instance();

  wkit->begin_style("NfcInfoStyle","NfcInfoFont");

  // Buttons zur Auswahl der Lernmethoden erstellen
  _prozent_bt = wkit->check_box(Txt(207), nil);
  _dauer_bt   = wkit->check_box(Txt(206), nil);

  // Eingabefelder zur definition der Groessen erstellen
  _prozent_ed     = new EingabeFeld(4, _neue_strukt.prozent, nil);
  _dauer_ed       = new EingabeFeld(4, _neue_strukt.dauer, nil);
  _min_treffer_ed = new EingabeFeld(4, _neue_strukt.min_treffergrad, nil);

  // Button zum Fuzzy-Set optimieren definieren
  _fuz_opt_bt = wkit->check_box(Txt(227), nil);

  // Button fuer Ende und Abbruch definieren
  Action* cb  = new ActionCallback(LernEd)(this,&LernEd::_ende);
  Button* bt1 = wkit->push_button(Txt(87), cb);
  cb          = new ActionCallback(LernEd)(this,&LernEd::_abbruch);
  Button* bt2 = wkit->push_button(Txt(90), cb);

  body(
    new Background(
      lkit->margin(
        lkit->vbox(
          nkit->text_davor(Txt(205),
            lkit->vbox(
              lkit->hbox(
                lkit->vcenter(_prozent_bt),
                lkit->vcenter(lkit->hflexible(_prozent_ed, 0, 0)),
                lkit->vcenter(wkit->label(Txt(209))),
                lkit->hglue(0, fil, 0)
              ),
              lkit->hbox(
                lkit->vcenter(_dauer_bt),
                lkit->vcenter(lkit->hflexible(_dauer_ed, 0, 0)),
                lkit->vcenter(wkit->label(Txt(208))),
                lkit->hglue(0, fil, 0)
              )
            ), false
          ), lkit->vglue(rand, 0, 0),
          nkit->text_davor(
            Txt(210),
            lkit->hflexible(_min_treffer_ed, 0, 0),
            false
          ), lkit->vglue(rand, 0, 0),
          lkit->hbox(_fuz_opt_bt, lkit->hglue()),
          lkit->vglue(2 * rand, 0, 0),
          lkit->hbox(
            lkit->hglue(0, fil, 0),
            bt1, lkit->hglue(0, fil, 0),
            bt2, lkit->hglue(0, fil, 0)
          )
        ), rand, rand
      ), wkit->background()
    )
  );

  append_input_handler(_prozent_ed->input_handler());
  append_input_handler(_dauer_ed->input_handler());
  append_input_handler(_min_treffer_ed->input_handler());
  focus(_prozent_ed->input_handler());

  wkit->end_style();
}


/*
 *------------------------------------------------------------------------------
 * Elementfunktion : LernEd::lern_struktur()
 * Rueckgabewert : neu definierte RgLernStruktur
 * Zweck : siehe Rueckgabewert.
 *------------------------------------------------------------------------------
 */
RgLernStruktur* LernEd::lern_struktur() { return &_neue_strukt; }


/*
 *------------------------------------------------------------------------------
 * Elementfunktion : LernEdEd::einblenden(Window*, RgLernStruktur*)
 * Parameter : Window*         - Eltern-Fenster
 *             RgLernStruktur* - Default Struktur
 * Rueckgabewert : boolean - wurde Fenster mit 'Ende' oder 'Abbruch' verlassen.
 * Zweck : Der Lern-Editor (bzw. das Popup-Window) wird eingeblendet.
 *------------------------------------------------------------------------------
 */
boolean LernEd::einblenden(Window* f, RgLernStruktur* def)
{
  if(def != nil)
    _neue_strukt = *def;
  _init(&_neue_strukt);
  return post_for(f);
}


/*
 *------------------------------ lokale Funktionen -----------------------------
 */

void LernEd::_ende()
{
  // Buttons abfragen und Struktur initialisieren
  if(_prozent_bt->state()->test(TelltaleState::is_chosen)) {
    if(_prozent_ed->hol_wert(_neue_strukt.prozent))
      _neue_strukt.nach_prozent = true;
    else
      _neue_strukt.nach_prozent = false;
  } else
    _neue_strukt.nach_prozent = false;
  if(_dauer_bt->state()->test(TelltaleState::is_chosen)) {
    if(_dauer_ed->hol_wert(_neue_strukt.dauer))
      _neue_strukt.nach_dauer = true;
    else
      _neue_strukt.nach_dauer = true;
  } else
    _neue_strukt.nach_dauer = false;
  if(!_min_treffer_ed->hol_wert(_neue_strukt.min_treffergrad))
     _neue_strukt.min_treffergrad = 0;

  _neue_strukt.fuz_trainieren = _fuz_opt_bt->state()->test(
                                  TelltaleState::is_chosen
                                );
  dismiss(true);
}

void LernEd::_abbruch() { dismiss(false); }

void LernEd::_init(RgLernStruktur* struktur)
{
  if(struktur->nach_prozent)
    _prozent_bt->state()->set(TelltaleState::is_chosen, true);
  else
    _prozent_bt->state()->set(TelltaleState::is_chosen, false);
  if(struktur->nach_dauer)
    _dauer_bt->state()->set(TelltaleState::is_chosen, true);
  else
    _dauer_bt->state()->set(TelltaleState::is_chosen, false);
  if(struktur->fuz_trainieren)
    _fuz_opt_bt->state()->set(TelltaleState::is_chosen, true);
  else
    _fuz_opt_bt->state()->set(TelltaleState::is_chosen, false);

  _prozent_ed->setz_wert(struktur->prozent);
  _dauer_ed->setz_wert(struktur->dauer);
  _min_treffer_ed->setz_wert(struktur->min_treffergrad);
}
