/* NEFCON-I: an interactive system for realization of a neural fuzzy controller

   Copyright (C) 1994 

   Institut fuer Betriebssysteme und Rechnerverbund, Technische Universitaet
   Braunschweig, Bueltenweg 74/75, 38106 Braunschweig, Germany, 
   hereby disclaims all copyright interests in the program NEFCON-I 
   written by Hermann-Josef Diekgerdes and Roland Stellmach.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/




#include <stdio.h>
#include <string.h>
#include "global.h"

implementList(StringList,CopyString)

extern "C" {
  extern long random();
}

float rnd()
{
  float wuerfel = Abs(random());
  float null_bis_hundert = (int)(wuerfel) % 100;
  return null_bis_hundert / 100;
}

void hol_str(float zahl, char* str)
{
  int egal;
  hol_str(zahl, str, egal);
}

void hol_str(float zahl, char* str, int& laenge)
{
  sprintf(str, "%.3f", zahl);
  laenge = strlen(str);
  int i;
  for(i = laenge - 1; i > 0 && str[i] == '0' ; i--)
      str[i] = '\0';
  if(str[i] == '.')
    str[i] = '\0';
  laenge = strlen(str);
}

void tausch(float& a, float& b)
{
  float merk = a;
  a = b;
  b = merk;
}
