/* NEFCON-I: an interactive system for realization of a neural fuzzy controller

   Copyright (C) 1994 

   Institut fuer Betriebssysteme und Rechnerverbund, Technische Universitaet
   Braunschweig, Bueltenweg 74/75, 38106 Braunschweig, Germany, 
   hereby disclaims all copyright interests in the program NEFCON-I 
   written by Hermann-Josef Diekgerdes and Roland Stellmach.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/




#ifndef anwend_ed_h
#define anwend_ed_h

#include <OS/list.h>
#include <InterViews/action.h>

#include "nfclook.h"
#include "anwendung.h"
#include "lingvar.h"

declarePtrList(AButtonListe, AuswahlButton);

/*
 *------------------------------------------------------------------------------
 * Klasse : AnwendungsEd
 * Zweck  : Oeffnet ein Popup-Window, mit dessen Hilfe eine Anwendung erstellt
 *          bzw. initialisiert wird. Anwendungs-Programm darf waehrenddessen
 *          nicht laufen.
 *------------------------------------------------------------------------------
 */
class AnwendungsEd : public NfcDialogFenster
{
  public : AnwendungsEd(Anwendung*,
                        const LingVarSatz*,
                        Action* ok_cb,
                        Action* nook_cb);
           ~AnwendungsEd();
           Anwendung* anwendung();
  private: void _fertig();
           const LingVarSatz* _lingvarsatz;
           Anwendung* _anwendung;
           EingabeFeld* _namens_ed;
           NfcAusgabe* _ausgabefeld;
           AButtonListe _eingabe_liste,
                        _ausgabe_liste;
           Action *_ende_cb;
};

#endif
