/* NEFCON-I: an interactive system for realization of a neural fuzzy controller

   Copyright (C) 1994 

   Institut fuer Betriebssysteme und Rechnerverbund, Technische Universitaet
   Braunschweig, Bueltenweg 74/75, 38106 Braunschweig, Germany, 
   hereby disclaims all copyright interests in the program NEFCON-I 
   written by Hermann-Josef Diekgerdes and Roland Stellmach.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/





#include <InterViews/border.h>
#include <InterViews/rule.h>

#include "anwend_ed.h"

implementPtrList(AButtonListe, AuswahlButton);

declareActionCallback(AnwendungsEd);
implementActionCallback(AnwendungsEd);

// Definition des Menues
MenueStruktur AnwEd_menue[] = {
  { 66, nil },                   // "beenden"
  { 67, nil },                   // "abbrechen"
  { -1 }
};

MenueStruktur AnwEd_menue_bar[] = {
  { 65, nil, AnwEd_menue, 3 },   // "fertig"
  { -1 }
};

/*
 *------------------------------------------------------------------------------
 *------------------- Definition der Klasse : AnwendungsEd ---------------------
 *------------------------------------------------------------------------------
 */

/*
 * die Bezeichnungen 'Ein/Ausgabe' beziehen sich hier auf die Anwendung;
 * Eingabe-Variablen fuer den Controller sind Ausgabe-Variablen fuer
 * den Prozess (also die Anwendung) und umgekehrt.
 */

AnwendungsEd::AnwendungsEd(Anwendung* anwendung,
                           const LingVarSatz* lingvarsatz,
                           Action* ok_cb, 
                           Action* nook_cb)
  : NfcDialogFenster(nil)
{
  Coord rand = 10;

  _ende_cb = ok_cb;
  if(_ende_cb != nil)
    Resource::ref(_ende_cb);
  
  _lingvarsatz = lingvarsatz;

  int max_eingabe = _lingvarsatz->anz_lingvars(AusgabeVar);
  int max_ausgabe = _lingvarsatz->anz_lingvars(EingabeVar);

  // Vorbedingung : anwendung und lingvarsatz muessen kompatibel sein
  //                oder anwendung == nil
  if(anwendung == nil)
    _anwendung = new Anwendung(lingvarsatz);
  else
    _anwendung = new Anwendung(*anwendung);

  WidgetKit* wkit = WidgetKit::instance();
  LayoutKit* lkit = LayoutKit::instance();
  NfcKit* nkit    = NfcKit::instance();

  // Menue installieren
  Action* call = new ActionCallback(AnwendungsEd)(this, &AnwendungsEd::_fertig);
  AnwEd_menue[0].cb = call;
  AnwEd_menue[1].cb = nook_cb;
  Menu* menue_balken = nkit->menue(AnwEd_menue_bar, wkit, lkit);

  // Fuer jede Eingabe-Variable einen AuswahlButton erstellen, diesen in die
  // Liste eintragen und alle zusammen als Glyph fuer Ausgabe definieren
  Glyph* eingabe_glyph = lkit->vbox(lkit->vglue(rand));
  for(int i = 0; i < max_eingabe; i++) {
    AuswahlButton* bt = new AuswahlButton(wkit, nil);
    _eingabe_liste.append(bt);

    // Button initialisieren
    for(int j = 0; j < max_eingabe; j++)
      bt->zur_auswahl(_lingvarsatz->hol_lingvar(AusgabeVar, j)->name());

    // Default-Auswahl vorgeben
    String var_str = _anwendung->var(AusgabeVar, i);
    if(var_str == LeerStr)
      bt->auswahl_nr(i);
    else
      bt->auswahl(var_str);

    // Button in Grafik einbinden
    eingabe_glyph->append(lkit->hbox(bt, wkit->label("------>>")));
    eingabe_glyph->append(lkit->vglue(rand));
  }

  // dito fuer Ausgabe-Variablen
  Glyph* ausgabe_glyph = lkit->vbox(lkit->vglue(rand));
  for(i = 0; i < max_ausgabe; i++) {
    AuswahlButton* bt = new AuswahlButton(wkit, nil);
    _ausgabe_liste.append(bt);

    // Button initialisieren
    for(int j = 0; j < max_ausgabe; j++)
      bt->zur_auswahl(_lingvarsatz->hol_lingvar(EingabeVar, j)->name());

    // Default-Auswahl vorgeben
    String var_str = _anwendung->var(EingabeVar, i);
    if(var_str == LeerStr)
      bt->auswahl_nr(i);
    else
      bt->auswahl(var_str);

    // Button in Grafik einbinden
    ausgabe_glyph->append(lkit->hbox(wkit->label(">>------"), bt));
    ausgabe_glyph->append(lkit->vglue(rand));
  }

  // Eingabefeld fuer Namen definieren und diesen in Grafik einbauen
  _namens_ed = new EingabeFeld(12, "", nil);
  _namens_ed->text(_anwendung->name());
  Glyph* prozess_glyph = new Border(
                           lkit->margin(
                             lkit->v_variable_span(_namens_ed, 0, 0),
                             rand, fil, 0, rand, fil ,0,
                             rand, fil, 0, rand, fil, 0
                           ), wkit->foreground(), 2
                         );

  _ausgabefeld = new NfcAusgabe(new AusgabeFeld(40, 7));
  body(
    lkit->vbox(
      lkit->vcenter(
        lkit->hbox( lkit->variable_span(menue_balken, 0, 0), lkit->hglue())
      ),
      lkit->margin(
        lkit->vbox(
          lkit->hbox(
            lkit->center(nkit->text_drauf(Txt(108), eingabe_glyph, false)),
            lkit->center(nkit->text_drauf(Txt(109), prozess_glyph, false)),
            lkit->center(nkit->text_drauf(Txt(110), ausgabe_glyph, false))
          ), lkit->vglue(rand),
          nkit->text_drauf(Txt(40), _ausgabefeld, true)
        ), rand, rand
      )
    )
  );

  // Kurze Erklaerung einblenden
  _ausgabefeld->ausgeben(Info, Txt(107));
  _ausgabefeld->ausgeben(Info, Txt(105));
  _ausgabefeld->ausgeben(Info, Txt(106));
  _ausgabefeld->ausgeben(Info, LeerStr);

}

AnwendungsEd::~AnwendungsEd()
{
  if(_ende_cb != nil)
    Resource::unref(_ende_cb);
}

/*
 *------------------------------------------------------------------------------
 * Elementfunktion : AnwendungsEd::anwendung()
 * Rueckgabewert : Die neu definierte Anwendung.
 * Zweck : siehe Rueckgabewert.
 *------------------------------------------------------------------------------
 */
Anwendung* AnwendungsEd::anwendung() { return _anwendung; }

/*
 *-------------------------- lokale Funktionen ---------------------------------
 */

// Neue Anwendung aus den Angaben im Fenster erstellen
void AnwendungsEd::_fertig()
{
  NfcKit* nkit = NfcKit::instance();

  boolean ok = true;
  for(LingVarTyp typ = EingabeVar; ok && typ <= AusgabeVar; typ++) {
    AButtonListe& liste = (typ == EingabeVar) ? _ausgabe_liste : _eingabe_liste;

    // auf Doppelte testen
    int anzahl = _lingvarsatz->anz_lingvars(typ);
    for(int i = 0; ok && i < anzahl; i++)
      for(int j = 0; ok && j < anzahl; j++)
        if(i != j)
          ok = liste.item(i)->auswahl_nr() != liste.item(j)->auswahl_nr();
   }

  if(!ok) {
    if(typ == EingabeVar)
      _ausgabefeld->ausgeben(Fehler, Txt(113));
    else
      _ausgabefeld->ausgeben(Fehler, Txt(114));
  } else {

    // nur wenn alles in Ordnung ist '_anwendung' initialisieren
    Anwendung neue_anwendung(_lingvarsatz);

    // Namen des Prg.'s in '_anwendung' eintragen
    if(_namens_ed->text() != LeerStr)
      neue_anwendung.name(_namens_ed->text());
    else {
      _ausgabefeld->ausgeben(Fehler, Txt(112));
      return;
    }

    neue_anwendung.loesch_var(EingabeVar);  // alte Eintraege loeschen
    int anzahl = _lingvarsatz->anz_lingvars(EingabeVar);
    for(int i = 0; i < anzahl; i++)
      neue_anwendung.var(EingabeVar, _ausgabe_liste.item(i)->auswahl());

    neue_anwendung.loesch_var(AusgabeVar);  // alte Eintraege loeschen
    anzahl = _lingvarsatz->anz_lingvars(AusgabeVar);
    for(i = 0;  i < anzahl; i++)
      neue_anwendung.var(AusgabeVar, _eingabe_liste.item(i)->auswahl());

    *_anwendung = neue_anwendung;

    if(_ende_cb != nil)
      _ende_cb->execute();
  }
}
