/* PENDULUM: a graphical simulation of an inverted pendulum; part of 
   NEFCON-I: an interactive system for realization of a neural fuzzy controller

   Copyright (C) 1994 

   Institut fuer Betriebssysteme und Rechnerverbund, Technische Universitaet
   Braunschweig, Bueltenweg 74/75, 38106 Braunschweig, Germany, 
   hereby disclaims all copyright interests in the program NEFCON-I 
   written by Hermann-Josef Diekgerdes and Roland Stellmach.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef runge_h
#define runge_h

extern float pi();
extern int sgn(float);
extern float bog2grad(float);
extern float grad2bog(float);

class PendelSim
{
  public : PendelSim();
           void simulation(float kraft);

           float position();         // Position des Wagens
           void position(float);

           float wa_geschw();        // Geschwindigkeit des Wagens
           void wa_geschw(float);

           float winkel();           // Winkel des Pendels
           void winkel(float);

           float wi_geschw();        // Winkelgeschwindigkeit
           void wi_geschw(float);

  private: float _winkel(float, float, float, float);
           float _position(float, float, float, float, float);
           float _pi;
           float _werte[4];
};

inline float PendelSim::position()        { return _werte[0]; }
inline void PendelSim::position(float p)  { _werte[0] = p;    }

inline float PendelSim::wa_geschw()       { return _werte[1]; }
inline void PendelSim::wa_geschw(float g) { _werte[1] = g;    }

inline float PendelSim::winkel()          { return _werte[2]; }
inline void PendelSim::winkel(float w)    { _werte[2] = w;    }

inline float PendelSim::wi_geschw()       { return _werte[3]; }
inline void PendelSim::wi_geschw(float g) { _werte[3] = g;    }

#endif
