/* DATAGEN: a simple data generator for two variables with a GUI; part of
   NEFCON-I: an interactive system for realization of a neural fuzzy controller

   Copyright (C) 1994 

   Institut fuer Betriebssysteme und Rechnerverbund, Technische Universitaet
   Braunschweig, Bueltenweg 74/75, 38106 Braunschweig, Germany, 
   hereby disclaims all copyright interests in the program NEFCON-I 
   written by Hermann-Josef Diekgerdes and Roland Stellmach.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <iostream.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <IV-look/kit.h>
#include <InterViews/background.h>
#include <InterViews/session.h>
#include <InterViews/style.h>
#include <InterViews/window.h>
#include <InterViews/layout.h>
#include <Dispatch/dispatcher.h>
#include <Dispatch/iocallback.h>

#include "pendel_look.h"

class Prozess : public MonoGlyph
{
  public : Prozess();
  private: void _schreib();
           int _lies(int);
           void _start();
           void _ende();
           NfcAusgabe* _ausgabe_feld;
           EingabeFeld *_min1, *_max1, *_schritte1,
                       *_min2, *_max2, *_schritte2;
           float _wert1, _maxwert1, _minwert1, _step1,
                 _wert2, _maxwert2, _minwert2, _step2;
           boolean _fertig;
};

declareActionCallback(Prozess);
implementActionCallback(Prozess);

declareIOCallback(Prozess);
implementIOCallback(Prozess);

Prozess::Prozess()
{
  Coord rand = 10;

  WidgetKit* wkit = WidgetKit::instance();
  LayoutKit* lkit = LayoutKit::instance();
  NfcKit* nkit    = NfcKit::instance();

  _fertig = true;

  Action* cb     = new ActionCallback(Prozess)(this, &Prozess::_schreib);
  _ausgabe_feld  = new NfcAusgabe(new AusgabeFeld(20, 5));

  _min1      = new EingabeFeld(8, 0, cb, nil);
  _max1      = new EingabeFeld(8, 0, cb, nil);
  _schritte1 = new EingabeFeld(8, 0, cb, nil);
  _min2      = new EingabeFeld(8, 0, cb, nil);
  _max2      = new EingabeFeld(8, 0, cb, nil);
  _schritte2 = new EingabeFeld(8, 0, cb, nil);

  IOHandler* ptr = new IOCallback(Prozess)(this, &Prozess::_lies);

  cb              = new ActionCallback(Prozess)(this, &Prozess::_start);
  Glyph* start_bt = wkit->push_button("Start", cb);
  cb              = new ActionCallback(Prozess)(this, &Prozess::_ende);
  Glyph* ende_bt  = wkit->push_button("End", cb);

  Dispatcher::instance().link(0, Dispatcher::ReadMask, ptr);

  body(
    lkit->margin(
      lkit->vbox(
        lkit->hbox(
          lkit->hglue(rand),
          nkit->text_drauf("min", _min1, true),               lkit->hglue(rand),
          nkit->text_drauf("max", _max1, true),               lkit->hglue(rand),
          nkit->text_drauf("step width", _schritte1, true), lkit->hglue(rand)
        ), lkit->vglue(rand),
        lkit->hbox(
          lkit->hglue(rand),
          nkit->text_drauf("min", _min2, true),               lkit->hglue(rand),
          nkit->text_drauf("max", _max2, true),               lkit->hglue(rand),
          nkit->text_drauf("step width", _schritte2, true), lkit->hglue(rand)
        ), lkit->vglue(rand),
        lkit->hbox(
          lkit->hglue(rand),
          lkit->vcenter(start_bt),
          lkit->hglue(rand),
          lkit->vcenter(ende_bt),
          lkit->hglue(rand)
        ),
        nkit->text_drauf(
          "Messages", new Background(_ausgabe_feld, wkit->background()), true)
      ), 10, 10
    )
  );
}

void Prozess::_schreib()
{
  if(!_fertig) {
    cout << _wert1 << '\n';
    _wert1 += _step1;
    cout << _wert2 << '\n';
    cout.flush();
    if(_wert1 > _maxwert1) {
      _wert1 = _minwert1;
      _wert2 += _step2;
      if(_wert2 > _maxwert2) {
        _ausgabe_feld->ausgeben(Info, "done");
        _fertig = true;
      }
    }
  }
}

int Prozess::_lies(int)
{
  char str[50];
  if(cin >> str) {
  } else {
    cout << EOF;
    cout.flush();
    _ende();
  }
  _schreib();
  return 0;
}

void Prozess::_start()
{
  boolean ok = true;
  float wert;

  ok = ok && _min1->hol_wert(wert);
  _wert1 = wert;
  _minwert1 = wert;

  ok = ok && _max1->hol_wert(wert);
  _maxwert1 = wert;

  ok = ok && _schritte1->hol_wert(wert);
  _step1 = wert;

  ok = ok && _min2->hol_wert(wert);
  _wert2 = wert;
  _minwert2 = wert;

  ok = ok && _max2->hol_wert(wert);
  _maxwert2 = wert;

  ok = ok && _schritte2->hol_wert(wert);
  _step2 = wert;

  ok = ok && _step1 != 0;
  ok = ok && _step2 != 0;
  ok = ok && _minwert1 < _maxwert1;
  ok = ok && _minwert2 < _maxwert2;

  _fertig = !ok;
  if(ok)
    _ausgabe_feld->ausgeben(Info, "started");
  else
    _ausgabe_feld->ausgeben(Info, "incorrect values");
  _schreib();
}

void Prozess::_ende()
{
  Session::instance()->quit();
}

//------------------------------------------------------------------------------

static PropertyData props[] = {
    { "*NfcInfoFont*font",     "*helvetica-bold-r-normal--12*" },
    { nil }
};

static OptionDesc options[] = { { nil } };

int main(int argc, char** argv)
{
  Session* session = new Session("nfc", argc, argv, options, props);
  WidgetKit& kit = *WidgetKit::instance();

  Style* style = kit.style();
  style->attribute("name", "Data Generator");

  Prozess* TheProzess = new Prozess();
  Window* haupt_fenster = new ApplicationWindow(
                            new Background(TheProzess, kit.background())
                          );

  session->run_window(haupt_fenster);
}

