/*
 *   Grafik-Modul fuer Pendelsimulation ( header-datei )
 *   (c) Diekgerdes
 *   26.08.'92
 */

#ifndef pendel_h
#define pendel_h

#include <Dispatch/iocallback.h>
#include <InterViews/monoglyph.h>
#include <InterViews/input.h>
#include <InterViews/patch.h>
#include "pendel_look.h"
#include "aric.h"

/*
 *------------------ Deklaration der Klasse : PendelFenster --------------------
 */

class PendelGrafik;

class PendelFenster : public InputHandler
{
  public : PendelFenster(Style*);
           ~PendelFenster();

  // lokale Funktionen
  private: int _lies_steuer_wert(int);
           void _schreib_messwerte();

           void _setz_winkel();
           void _setz_wi_geschw();
           void _setz_position();
           void _setz_wa_geschw();

           void _setz_strecke();
           void _setz_auto_start();
           void _setz_rnd_winkel();
           void _setz_sync();

           void _zufaelliger_winkel();
           void _zufaellige_geschw();

           void _start();
           void _stop();
           void _ende();

           void _zaehler_reset();

  // Zustandsvariablen
  private: PendelSim* _pend_sim;
           boolean _aktiv;
           int _zaehler;
           boolean _winkel_ausgeben, _wi_geschw_ausgeben,
                   _position_ausgeben, _wa_geschw_ausgeben,
                   _strecke_begrenzt;
           float _laenge_strecke;
           float _alte_pos;
           boolean _auto_start,
                   _rnd_winkel;
           int _sync_faktor;
           boolean _toggle1, _toggle2;
           int _anzahl_zyklen;
           char _buffer[50];         // Hilfsbuffer

  // Grafikelemente
  private: PendelGrafik* _pendel;
           Patch* _grafik;
           EingabeFeld *_winkel_ed, *_wi_geschw_ed,
                       *_position_ed, *_wa_geschw_ed,
                       *_strecke_ed, *_sync_ed;
           NfcAusgabe* _ausgabefeld;
           NfcLabel* _zaehler_feld;
};

#endif
