#ifndef nfc_global_h
#define nfc_global_h

#include <OS/string.h>
#include <OS/list.h>

#define Min(a,b) ((a)<(b)?(a):(b))
#define Max(a,b) ((a)>(b)?(a):(b))
#define Abs(a)   ((a)>(0)?(a):(-1*(a)))
#define Sgn(a)   ((a)<(0)?(0):(1))

declareList(StringList,CopyString);

extern float rnd();

extern void hol_str(float zahl, char* str);
extern void hol_str(float zahl, char* str, int& anzahl);

extern void tausch(float& a, float& b);

enum AusgabeTyp { Fehler, Warnung, Meldung, Info };

/*
 *------------------------------------------------------------------------------
 * Klasse : Ausgabe
 * Zweck  : Deklariert die Funktionen zur Ausgabe von Fehlermeldungen.
 *------------------------------------------------------------------------------
 */
class Ausgabe
{
  public : virtual void ausgeben(AusgabeTyp, String) = 0;
           virtual void ausgeben(AusgabeTyp, String, String) = 0;
           virtual void ausgeben(AusgabeTyp, String, String, String) = 0;
};

#endif
