#ifndef aric_h
#define aric_h

extern float pi();
extern int sgn(float);
extern float bog2grad(float);
extern float grad2bog(float);

class PendelSim
{
  public : PendelSim();
           void simulation(float kraft);

           float position();         // Position des Wagens
           void position(float);

           float wa_geschw();        // Geschwindigkeit des Wagens
           void wa_geschw(float);

           float winkel();           // Winkel des Pendels
           void winkel(float);

           float wi_geschw();        // Winkelgeschwindigkeit
           void wi_geschw(float);

  private: float _winkel(float, float, float, float);
           float _position(float, float, float, float, float);
           float _pi;
           float _werte[4];
};

inline float PendelSim::position()        { return _werte[0]; }
inline void PendelSim::position(float p)  { _werte[0] = p;    }

inline float PendelSim::wa_geschw()       { return _werte[1]; }
inline void PendelSim::wa_geschw(float g) { _werte[1] = g;    }

inline float PendelSim::winkel()          { return _werte[2]; }
inline void PendelSim::winkel(float w)    { _werte[2] = w;    }

inline float PendelSim::wi_geschw()       { return _werte[3]; }
inline void PendelSim::wi_geschw(float g) { _werte[3] = g;    }

#endif
