/*--------------------------------------------------------------------------
 *  Copyright (c) 1994, University of Stuttgart, IFR, All rights reserved.
 *
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any non-commercial purpose without fee is hereby granted,
 *  provided that the above copyright notice appears in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation.
 *
 *  THE IFR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 *  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 *  THE IFR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 *  ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 *  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 *  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 *  SOFTWARE.
 *---------------------------------------------------------------------------
 *  email:Postmaster@IFR.Luftfahrt.Uni-Stuttgart.DE                         
 *--------------------------------------------------------------------------
 */


#include<math.h>
#include "cmex.h"


#define IN1 prhs[0]   /* erste matrix: x */
#define IN2 prhs[1]   /* zweite matrix: y */
#define IN3 prhs[2]   /* d_step */
#define IN4 prhs[3]   /* spezifikation des operators */

#define OUT1 plhs[0]  /* resultat der verknpfung */
#define OUT2 plhs[1]  /* groesse von OUT1  */


#define min(a,b) ( (a<=b) ? a : b )
#define max(a,b) ( (a>=b) ? a : b )


user_fcn(nlhs, plhs, nrhs, prhs)
  int nlhs, nrhs;
  Matrix *plhs[], *prhs[];
  {  
  float sx,sy,ex,ey,ss1,ss2;
  float len,xx,d_step,fix,fiy;
  float param,mu_x,mu_y;
  int ilen,i,ix,iy,undop;
  
  ss1=(IN1->pr)[0];
  ss2=(IN2->pr)[0];
  d_step=(IN3->pr)[0];
  undop=(int) (IN4->pr)[0];
  if(undop>5) param=(IN4->pr)[1];
    

  if(ss1<=ss2)
  {

  sx=ss1;
  sy=ss2;
  ex=(IN1->pr)[1];
  ey=(IN2->pr)[1];

  
  
   if(ey>ex) 
     {
     len=(ey-sx)/d_step+3.0;
     ilen=(int) len;
     OUT1=create_matrix(1,len,REAL);
     (OUT1->pr)[0]=sx;
     (OUT1->pr)[1]=ey;
     OUT2=create_matrix(1,1,REAL);
     (OUT2->pr)[0]=len;  
     i=2;
     for(xx=sx;xx<ey;xx+=d_step)
     {

        fix=fabs( (xx-sx)/d_step+2.5 );
     	fiy=fabs( (xx-sy)/d_step+2.5 );	
     	ix=(int) fix;
     	iy=(int) fiy;
	
     	if(xx<=sy)
	   {
           if(xx>=ex)
	  	{
	  	mu_y=0;
	  	mu_x=0;
	  	goto quick;
	  	}
	   else
	  	{
          	mu_y=0;
          	mu_x=(IN1->pr)[ix];
	  	goto quick;
	  	}
	   }

      	if(xx>=ex)
	   {
	   if(xx<=sy)
	  	{
		mu_x=0;
	  	mu_y=0;
	  	goto quick;
	  	}
	   else
  	  	{
	  	mu_y=(IN2->pr)[iy];
	  	mu_x=0;
          	goto quick;
	  	}
	   }

        mu_x=(IN1->pr)[ix];
	mu_y=(IN2->pr)[iy];
     	quick:
     	;
	switch(undop)
	{
	case 1: (OUT1->pr)[i++]=min(mu_x,mu_y); break;
	case 2: (OUT1->pr)[i++]=max(0.,mu_x+mu_y-1); break;
	case 3: if(mu_x<0.0001 && mu_y<0.0001)
		    {
		    (OUT1->pr)[i++]=0.;
		    }
		else
		    {  
		    (OUT1->pr)[i++]=(mu_x+mu_y)/(2.+(mu_x+mu_y-mu_x*mu_y));
		    }
		break;
	case 4: (OUT1->pr)[i++]=mu_x*mu_y; break;
	case 5: if(mu_x<0.0001 && mu_y<0.0001)
		    {
		    (OUT1->pr)[i++]=0.;
		    }
		else
		    {
		    (OUT1->pr)[i++]=(mu_x*mu_y)/(mu_x+mu_y-mu_x*mu_y);
		    }
		break;
	case 6: (OUT1->pr)[i++]=param*min(mu_x,mu_y)+0.5*(1.-param)*(mu_x+mu_y); 

	}
	
	} /* ende der xx-schleife */
   }        /* ende des zweiges ey>ex */
   else     /* else-zweig, also hier ey<ex */   
     {
     len=(ex-sx)/d_step+3.0;
     ilen=(int) len;
     OUT1=create_matrix(1,ilen,REAL);
     (OUT1->pr)[0]=sx;
     (OUT1->pr)[1]=ex;
     OUT2=create_matrix(1,1,REAL);
     (OUT2->pr)[0]=len;  
     i=2;
     for(xx=sx;xx<ex;xx+=d_step)
     {

        fix=fabs( (xx-sx)/d_step+2.5 );
     	fiy=fabs( (xx-sy)/d_step+2.5 );	
     	ix=(int) fix;
	iy=(int) fiy;
	
	if(xx<sy)
	  {
	  mu_x=(IN1->pr)[ix];
	  mu_y=0;
	  goto quick11;
	  }
	if(xx>ey)
	  {
	  mu_x=(IN1->pr)[ix];
	  mu_y=0;
	  goto quick11;
	  }
	mu_x=(IN1->pr)[ix];
	mu_y=(IN2->pr)[iy];

	quick11:
	;

	switch(undop)
	{
	case 1: (OUT1->pr)[i++]=min(mu_x,mu_y); break;
	case 2: (OUT1->pr)[i++]=max(0.,mu_x+mu_y-1); break;
	case 3: if(mu_x<0.0001 && mu_y<0.0001)
		    {
		    (OUT1->pr)[i++]=0.;
		    }
		else
		    {  
		    (OUT1->pr)[i++]=(mu_x+mu_y)/(2.+(mu_x+mu_y-mu_x*mu_y));
		    }
		break;
	case 4: (OUT1->pr)[i++]=mu_x*mu_y; break;
	case 5: if(mu_x<0.0001 && mu_y<0.0001)
		    {
		    (OUT1->pr)[i++]=0.;
		    }
		else
		    {
		    (OUT1->pr)[i++]=(mu_x*mu_y)/(mu_x+mu_y-mu_x*mu_y);
		    }
		break;
	case 6: (OUT1->pr)[i++]=param*min(mu_x,mu_y)+0.5*(1.-param)*(mu_x+mu_y); 

	}
     }  /* ende der xx-schleife */
	
   }     /* ende des else-zweiges von ey>ex  */

  }    /* ende des zweiges wenn ss1<ss2 */

  else   /* else-zweig von ss1, also hier ss1>ss2, fall b, y vor x */
  {

  sx=ss2;
  sy=ss1;
  ex=(IN2->pr)[1];
  ey=(IN1->pr)[1];
  
  
  if(ey>ex)
    {
    len=(ey-sx)/d_step+3.0;
    ilen=(int) len;
    OUT1=create_matrix(1,ilen,REAL);
    (OUT1->pr)[0]=sx;
    (OUT1->pr)[1]=ey;
    OUT2=create_matrix(1,1,REAL);
    (OUT2->pr)[0]=len;

    i=2;
    for(xx=sx;xx<ey;xx+=d_step)
     {

     fix=fabs( (xx-sx)/d_step+2.5 );
     fiy=fabs( (xx-sy)/d_step+2.5 );
     ix=(int) fix;
     iy=(int) fiy;

     if(xx<=sy)
	{
	if(xx>=ex)
	  {
	  mu_y=0;
	  mu_x=0;
	  goto quick1;
	  }
	else
	  {
	  mu_y=0;
	  mu_x=(IN2->pr)[ix];
	  goto quick1;
	  }
	}

     if(xx>=ex)
	{
	if(xx<=sy)
	  {
	  mu_x=0;
	  mu_y=0;
	  goto quick1;
	  }
	else
	  {
	  mu_y=(IN1->pr)[iy];
	  mu_x=0;
	  goto quick1;
	  }
	}

     mu_x=(IN2->pr)[ix];
     mu_y=(IN1->pr)[iy];

     quick1:
     ;

     switch(undop)
	{
	case 1: (OUT1->pr)[i++]=min(mu_x,mu_y); break;
	case 2: (OUT1->pr)[i++]=max(0.,mu_x+mu_y-1); break;
	case 3: if(mu_x<0.0001 && mu_y<0.0001)
		    {
		    (OUT1->pr)[i++]=0.;
		    }
		else
		    {  
		    (OUT1->pr)[i++]=(mu_x+mu_y)/(2.+(mu_x+mu_y-mu_x*mu_y));
		    }
		break;
	case 4: (OUT1->pr)[i++]=mu_x*mu_y; break;
	case 5: if(mu_x<0.0001 && mu_y<0.0001)
		    {
		    (OUT1->pr)[i++]=0.;
		    }
		else
		    {
		    (OUT1->pr)[i++]=(mu_x*mu_y)/(mu_x+mu_y-mu_x*mu_y);
		    }
		break;
	case 6: (OUT1->pr)[i++]=param*min(mu_x,mu_y)+0.5*(1.-param)*(mu_x+mu_y); 

	}

     } /* ende der xx-schleife */
    } /* ende des zweiges ey>ex   */
  else  /* hier also ey<ex   */
    {
    len=(ex-sx)/d_step+3.0;
    ilen=(int) len;
    OUT1=create_matrix(1,ilen,REAL);
    (OUT1->pr)[0]=sx;
    (OUT1->pr)[1]=ex;
    OUT2=create_matrix(1,1,REAL);
    (OUT2->pr)[0]=len;
     i=2;
     for(xx=sx;xx<ex;xx+=d_step)
     {

        fix=fabs( (xx-sx)/d_step+2.5 );
     	fiy=fabs( (xx-sy)/d_step+2.5 );	
     	ix=(int) fix;
	iy=(int) fiy;
	
	if(xx<sy)
	  {
	  mu_x=(IN2->pr)[ix];
	  mu_y=0;
	  goto quick21;
	  }
	if(xx>ey)
	  {
	  mu_x=(IN2->pr)[ix];
	  mu_y=0;
	  goto quick21;
	  }
	mu_x=(IN2->pr)[ix];
	mu_y=(IN1->pr)[iy];

	quick21:
	;
	
	switch(undop)
	{
	case 1: (OUT1->pr)[i++]=min(mu_x,mu_y); break;
	case 2: (OUT1->pr)[i++]=max(0.,mu_x+mu_y-1); break;
	case 3: if(mu_x<0.0001 && mu_y<0.0001)
		    {
		    (OUT1->pr)[i++]=0.;
		    }
		else
		    {  
		    (OUT1->pr)[i++]=(mu_x+mu_y)/(2.+(mu_x+mu_y-mu_x*mu_y));
		    }
		break;
	case 4: (OUT1->pr)[i++]=mu_x*mu_y; break;
	case 5: if(mu_x<0.0001 && mu_y<0.0001)
		    {
		    (OUT1->pr)[i++]=0.;
		    }
		else
		    {
		    (OUT1->pr)[i++]=(mu_x*mu_y)/(mu_x+mu_y-mu_x*mu_y);
		    }
		break;
	case 6: (OUT1->pr)[i++]=param*min(mu_x,mu_y)+0.5*(1.-param)*(mu_x+mu_y); 

	}
     } /* ende der xx-schleife */
    }  /* ende des ex-else-zweiges  */
  } /* ende else-zweig ss1,ss2 */
  
  return 0;     
  } /* ende von user_fcn */
