function showvar(set)

%SHOWVAR
%         SHOWVAR(set) displays the input- and output-variables
%         of the fuzzy-description-set 'set' on the graphic-screen.
%         Note, that 'set' must be of type SET, i.e. SET must describe
%         input- and output-variables. 
%         To get a variable of type SET, use OUTDEF.
%
%         See also: INDEF, OUTDEF.

% Stephan Molt 01-09-93

close;
hold off;
scale=[0 1 0 1];
axis('off');
axis(scale);
hold on;
[z,s]=size(set);
% pruefen der argumente
if(nargin~=1)
  error('wrong number of arguments - SHOWSET requires one argument');
end
if(s~=48)
  error('arguement must be of type SET');
end

set=setstr(set);


text(0,1,'Input-Variables','sc');
text(0.5,1,'Output-Variables','sc');
zin=abs(set(1,1));
zout=abs(set(1,21));

for i=2:1:zin+1
    name=set(i,1:20);
    text(0,0.95-0.05*i,name,'sc');
    ab=set(i,21:24);
    for j=1:1:4
        if(ab(j)==0)
           ab(j)=32;
        end
    end
    ab=['(',ab,')'];
    text(0.2,0.95-0.05*i,ab,'sc');
end
for i=2:1:zout+1
    name=set(i,25:44);
    text(0.5,0.95-0.05*i,name,'sc');
    ab=set(i,45:48);	
    for j=1:1:4
        if(ab(j)==0)
	  ab(j)=32;
	end
    end
    ab=['(',ab,')'];
    text(0.7,0.95-0.05*i,ab,'sc');
end

return


%------------------------------------------------------------------------------
%  Copyright (c) 1994, University of Stuttgart, IFR, All rights reserved.
%
%  Permission to use, copy, modify, and distribute this software and its
%  documentation for any non-commercial purpose without fee is hereby granted,
%  provided that the above copyright notice appears in all copies and that
%  both that copyright notice and this permission notice appear in
%  supporting documentation.
% 
%  THE IFR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
%  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
%  THE IFR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
%  ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
%  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
%  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
%  SOFTWARE.
%---------------------------------------------------------------------------
%  email:Postmaster@IFR.Luftfahrt.Uni-Stuttgart.DE
