function showset(set,setdesc,inout,nr)

%SHOWSET
%         SHOWSET(set,setdesc,inout,n) displays the fuzzy-set of a 
%         variable.
%         If parameter inout=1 the n-th input-variable is displayed, if 
%         inout=2 the n-th output-variable is displayed.
%         Paramter n is optional; if you decide to call SHOWSET with
%         only three parameters you will be asked which linguistic
%         variable shall be displayed.
%         'set' must be of type SET and 'setdesc' must be of type SET-
%         DESC.
%         It is possible to display a fuzzy-set of an extended set-des-
%         cription-matrix also; therefore you have to replace 'n' by its
%         negative value and replace 'setdesc' by 'extsetdesc'.
%
%         To get these types see OUTDEF, MAKESET.

% Stephan Molt 01-09-93

close;
hold off;
% check der argumente
[zz1,ss1]=size(set);
if(ss1~=48)
   error('the first argument must be of type SET');
end

n_in=abs(set(1,1));
n_out=abs(set(1,21));

name=[];
setstr(name);
if (nargin==3)
    % hier wurde das letzte argument weggelassen
    clc;
    if inout==1
       disp('List of INPUT-Variables:');
       disp(' ');
       for t=1:1:n_in
             
          name=[num2str(t),'-',set(t+1,1:20)];
          disp(name);
       end  
    else
      disp('List of OUTPUT-Variables:');
      disp(' ');

      for t=1:1:n_out 
          name=[num2str(t),'-',set(t+1,25:44)];
          disp(name);
      end  

    end
    while 1==1
      nr=input('Please type the nr of variable you want to see! ');
      if (isstr(nr))
          disp('Please enter a number and not a character!!');
      else
          break;
      end
    end
end
inout=abs(inout);
if(inout>2) 
  inout=2;
end

% evtl. ungueltige angaben abfangen
if(inout==1 & nr>n_in)
  error('this input-variable does not exist - use a lower identifier');
elseif(inout==2 & nr>n_out)
  error('this output-variable does not exist - use a lower identifier');
end


if(nr>0)
  if(inout==1)
    start=1;
    ende=20;
  else
    start=25;
    ende=44;
  end

  var=set(nr+1,start:ende);
  if(inout==1)
   var=[' Input-Variable ',num2str(nr),': ',var];
  else
   var=[' Output-Variable ',num2str(nr),': ',var];
  end
  ein=setdesc(nr,(inout*3-2));
  string=lingus(ein);

  x0=setdesc(nr,(inout*3-1));
  a=setdesc(nr,inout*3);

  h0=a/ein;
  anz1=ein-2;
  anz2=ein+1;
  aus=2*ein-2;
  st=x0-a;
% h0 ist normierte  schrittweite
  clg;
  scale=[x0-a*1.1,x0+a*1.1,0,2];
  axis(scale);
  hold on;
  f0=[x0,x0,h0,h0,1];
  tshow(f0);
  text(x0,1.05,'ZE');
  title(var);
  clear var;
  hold on;
  for i=1:2:anz1;
   if(i==1)
    f=[st,st+2*h0,0,h0,1];
   else
    f=[st+i*h0,st+(i+1)*h0,h0,h0,1];
   end
   tshow(f);
   x=st+i*h0;
   text(x,1.05,string((i+1)/2,1:3));
  end
  for i=anz2:2:aus;
   if(i==aus)
    f=[st+i*h0,st+(i+2)*h0,h0,0,1];
   else
    f=[st+i*h0,st+(i+1)*h0,h0,h0,1];
   end
   tshow(f);
   x=st+i*h0;
   text(x,1.05,string((i+2)/2,1:3));
  end
  hold off;

else  %hier negativer wert, d.h. es wird extsetdesc dargestellt

  nr=abs(nr);
  if(inout==1)
    start=1;
    ende=20;
  else
    start=25;
    ende=44;
  end 
  

  var=set(nr+1,start:ende);
  if(inout==1)
   var=[' Input-Variable ',num2str(nr),': ',var];
  else
   var=[' Output-Variable ',num2str(nr),': ',var];
  end
  var=['EXTENDED SET : ',var]; 

  if(inout==1)
    z=nr;
  else
    z=nr+n_in;
  end

    sections=setdesc(z,1);
    string=lingus(sections);

    N=setdesc(z,2);
    alpha=setdesc(z,4);

    M=setdesc(z,sections*4-1);
    beta=setdesc(z,sections*4+1);

    x0=N-alpha-0.1*abs(N-alpha);
    xe=M+beta+0.1*abs(M+beta);
    clg;
    scale=[x0,xe,0,2];
    axis(scale);
    hold on;
    for i=1:1:sections
      N=setdesc(z,i*4-2);
      M=setdesc(z,i*4-1);
      alpha=setdesc(z,i*4);
      beta=setdesc(z,i*4+1);
      f=[N,M,alpha,beta,1];
      tshow(f,2,0);
      text(N,1.1+0.05*(-1)^i,string(i,1:3));
       
   end

    title(var);
    hold off;
end;

return


%------------------------------------------------------------------------------
%  Copyright (c) 1994, University of Stuttgart, IFR, All rights reserved.
%
%  Permission to use, copy, modify, and distribute this software and its
%  documentation for any non-commercial purpose without fee is hereby granted,
%  provided that the above copyright notice appears in all copies and that
%  both that copyright notice and this permission notice appear in
%  supporting documentation.
% 
%  THE IFR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
%  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
%  THE IFR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
%  ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
%  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
%  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
%  SOFTWARE.
%---------------------------------------------------------------------------
%  email:Postmaster@IFR.Luftfahrt.Uni-Stuttgart.DE
