function [Rs,SD]=prepare(set,setdesc,rule)

%PREPARE
%         [Rs,SD]=prepare(set,setdesc,rule)
%         PREPARE returns matrices Rs and SD which are needed if you want
%         to use the UNFUZZY2-command for defuzzification.
%         set must be of type SET, setdesc must be a set-descrption-ma-
%         trix; rule must be a matrix containing your rules.
%
%         See also UNFUZZY2

% Stephan Molt 01-09-93

[zz1,ss1]=size(set);
% pruefen der argumente
if(ss1~=48) 
   error('the first argument must be of type SET');
end

% zahl der ausgangs-(steuer-)groessen
nr_out=abs(set(1,21));

% schauen, welche ausgangsgroesse die meisten unterteilungen hat
outsections=setdesc(1:nr_out,4);

max_sd=max(outsections);
SD=zeros(nr_out,max_sd);

[void,rmax]=size(rule);
rmax=rmax/3;
Rs=zeros(nr_out,rmax);


% bereitstellen der groessen nach der area-methode
for ii=1:1:nr_out


      x0=setdesc(ii,5);
      a=setdesc(ii,6);
      sections=setdesc(ii,4);
      st=x0-a;
      h0=a/sections;
      anz1=sections-2;
      anz2=sections+1;
      aus=2*sections-2;

      j=0;

%     zuerst wird der vordere negative bereich untersucht
%     herausfiltern der fuzzy-zahlen und berechnen der einzelnen
%     schwerpunkte

      for i=1:2:anz1;
      	j=j+1;
      	if(i==1)
     		f=[st,st+2*h0,0,h0,1];
      	else
     		f=[st+i*h0,st+(i+1)*h0,h0,h0,1];
      	end

	[SD(ii,j),void,void]=tunfuzzy(f);

      end

%     dann wird die null untersucht

      j=j+1;
      f=[x0,x0,h0,h0,1];      
      [SD(ii,j),void,void]=tunfuzzy(f);

%    als letztes wird der hintere, positive bereich geprft;

      for i=anz2:2:aus;
       j=j+1;
       if(i==aus)
        f=[st+i*h0,st+(i+2)*h0,h0,0,1];
       else
	f=[st+i*h0,st+(i+1)*h0,h0,h0,1];
       end

       [SD(ii,j),void,void]=tunfuzzy(f);	

      end

end


for ii=1:1:rmax
	for jj=1:1:nr_out
		Rs(jj,ii)=rule(jj,ii*3-1);
	end
end

return


%------------------------------------------------------------------------------
%  Copyright (c) 1994, University of Stuttgart, IFR, All rights reserved.
%
%  Permission to use, copy, modify, and distribute this software and its
%  documentation for any non-commercial purpose without fee is hereby granted,
%  provided that the above copyright notice appears in all copies and that
%  both that copyright notice and this permission notice appear in
%  supporting documentation.
% 
%  THE IFR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
%  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
%  THE IFR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
%  ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
%  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
%  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
%  SOFTWARE.
%---------------------------------------------------------------------------
%  email:Postmaster@IFR.Luftfahrt.Uni-Stuttgart.DE
