/*--------------------------------------------------------------------------
 *  Copyright (c) 1994, University of Stuttgart, IFR, All rights reserved.
 *
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any non-commercial purpose without fee is hereby granted,
 *  provided that the above copyright notice appears in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation.
 *
 *  THE IFR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 *  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 *  THE IFR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 *  ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 *  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 *  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 *  SOFTWARE.
 *---------------------------------------------------------------------------
 *  email:Postmaster@IFR.Luftfahrt.Uni-Stuttgart.DE                         
 *--------------------------------------------------------------------------
 */


#include<math.h>

#include"cmex.h"

#define IN1 prhs[0] /* IN1 ist vektor der aggregierten aj */
#define IN2 prhs[1] /*IN2 ist regel-matrix*/
#define IN3 prhs[2] /*IN3 ist spezifikation des inferenz-op*/
#define IN4 prhs[3] /* IN4 ist nr des outputs */
#define IN5 prhs[4] /* IN5 ist setdesc */
#define IN6 prhs[5] /* IN6 ist d_step der entspr. var */
#define IN7 prhs[6] /* IN7 ist der oder-operator */

#define OUT1 plhs[0] /* enthlt die diskrete fuzzy-zahl */
#define OUT2 plhs[1] /* enthlt die jeweiligen gren der matrizen */


#define min(a,b) ( (a<=b) ? a : b )
#define max(a,b) ( (a>=b) ? a : b )


user_fcn(nlhs, plhs, nrhs, prhs)
  int nlhs, nrhs;
  Matrix *plhs[], *prhs[];
  
  {
  Matrix *mu_d[4],*res[2];

  int ii,ilen,infop,zmax,i,j,nin,nr_out,rule,oderop;
  int elemente,k;
  float length,len;
  float aj;
  float set_nr,sections,m,i0,i1,h0,st;
  float M,N,alpha,beta,mu;
  float fi,x0,a;
  float start,ziel,d_step;

      
/*  	fi,ii,i,j,k - laufvariable
	zmax - zeilenzahl der matrix setdesc
	infop - inferenzoperator
	oderop - oderoperator
    	nin, nout - zahl der eingangs- und ausgangsgren
	nr_out - aktuelle nr der ausgangsgre, also z.B. 2 von 4
		 d.h. wenn mehrere ausgangsgrssen vorhanden sind
		 mu inferenz mehrmals aufgerufen werden
	rule - anzahl der regeln
	elemente - anzahl der elemente der diskreten fuzzy-zahl
	aj - aggregierte aij
	set_nr - nr des durch RULE bergebenen sets
	sections - anzahl der unterteilungen dieses parameters
	M, N, alpha, beta, mu - fuzzy-zahl
	st, x0, a, h0 - hilfsvariablen um set_nr zu ermitteln
	i0, i1 -        (  - " - )
	start, ziel - bernommen aus DISCRET.M
	d_step - diskretisierungs-schrittweite
	mu_d[0] - enthlt diskrete fuzzy-zahl- alt
   	mu_d[1] - enthlt neue diskr. fuzzy-zahl
	mu_d[2] - enthlt d_step fr aufruf 	
	mu_d[3] - enthlt den oder-operator	*/


/* aufruf mit inferenz(aj,rule,infop,nr_out,setdesc,d_step,oder_op) */
  
  nr_out=(IN4->pr)[0];
  nin=IN2->m;
  rule=(IN2->n)/3;
  zmax=IN5->m;
  infop=(int) (IN3->pr)[0];
  d_step=(IN6->pr)[0];  
  oderop=(IN7->pr)[0];

  

  i=nr_out;
    {

    /* def. von vektor alt, anfordern von speicher fr diesen vektor */
    /* es wird der schlechteste fall angenommen, da erstes und letztes set
       set durch regel gefordert werden */

    x0=(IN5->pr)[4*zmax+i-1];
    a=(IN5->pr)[5*zmax+i-1];
    start=x0-a; ziel=x0+a;
    len=3.+(ziel-start)/d_step;
    ilen=(int) len;
    /* alte matrix ist stets mu_d_0 */
    mu_d[0]=create_matrix(1,ilen,REAL);    
    mu_d[1]=create_matrix(1,ilen,REAL);

    mu_d[3]=create_matrix(1,1,REAL);
    (mu_d[3]->pr)[0]=oderop;

    for(ii=0;ii<ilen;ii++)
	      {
	      (mu_d[0]->pr)[ii]=0;
	      }

    mu_d[2]=create_matrix(1,1,REAL);
    (mu_d[2]->pr)[0]=d_step;
        
    
   
    for(j=1;j<=rule;j++)
      {
      for(ii=0;ii<ilen;ii++)
             (mu_d[1]->pr)[ii]=0;

/*    aus rule-matrix von regel j den wert des ausg i bestimmen bsp: 2 */
      set_nr=(IN2->pr)[(j*3-1-1)*nin+i-1];

/*    bestimmen des sets, das zu dieser zahl gehrt  */
      sections=(IN5->pr)[3*zmax+i-1];
      x0=(IN5->pr)[4*zmax+i-1];
      a=(IN5->pr)[5*zmax+i-1];
      h0=a/sections;
      st=x0-a;

      m=(sections+1.0)/2.0;
      if(set_nr==m)
	{
	/* mitte, also ZE erwischt */
	M=x0;
	N=x0;
	alpha=h0;
	beta=h0;
	mu=1.0;
	}
      else
	{
	if(set_nr<m)
	  {
	  /* neg bereich, vor mitte */
	  i0=2.0*set_nr-1.;
	  i1=2.0*set_nr;
	  }
	else
	  {
	  /* pos bereich */
	  i0=2.0*set_nr-2.0;
	  i1=2.0*set_nr-1.0;
	  }
	  N=st+i0*h0;
	  M=st+i1*h0;
	  alpha=h0;
	  beta=h0;
	  mu=1.0;
	}

/*    diskretisieren dieses sets f=[N,M,alpha,beta,1.0]    */

      start=N-alpha;
      ziel=M+beta;

      (mu_d[1]->pr)[0]=start; (mu_d[1]->pr)[1]=ziel;

      ii=1;
      /* eigentl. diskr.-routine */
      for(fi=start;fi<=N;fi+=d_step)
	   {
	   ii++;
	   (mu_d[1]->pr)[ii]=(alpha-N+fi)*mu/alpha;
	   }
      for(fi=N+d_step;fi<=M;fi+=d_step)
	   {
	   ii++;
	   (mu_d[1]->pr)[ii]=mu;
	   }
      for(fi=M+d_step;fi<=M+beta;fi+=d_step)
	   {
	   ii++;
	   (mu_d[1]->pr)[ii]=(M+beta-fi)*mu/beta;
	   }
      elemente=ii;

/*    inferenz von aj der i-ten var. und dieses sets->neu     */

      aj=(IN1->pr)[j-1];

      if(infop>4) infop=4;
      switch(infop)
        {
	case 1: break;
	case 2: 
            for(k=2;k<=elemente;k++)
	 	  {
		  if( (mu_d[1]->pr)[k]>aj ) (mu_d[1]->pr)[k]=aj;
		  }		
	    break;
	
	case 3:
	    for(k=2;k<=elemente;k++)
		  {
		  (mu_d[1]->pr)[k]=(mu_d[1]->pr)[k]*aj;
		  }
	    break;
	case 4: break;
	}

/*    ist j=1, dann mu keine verknpfung erfolgen, alt ist der wert
      der ersten variable, fr j=2 oder grer mu dann oder-verknpfung
      erfolgen                  */

      if(j==1)  
	{
	for(k=0;k<=elemente;k++)
	   (mu_d[0]->pr)[k]=(mu_d[1]->pr)[k];	
	}
      else
	{

/*      alt=dor(alt,neu)            */

	matlab_fcn(2,res,4,mu_d,"oder");

        k=(int) (res[1]->pr)[0];

	for(ii=0;ii<k;ii++)
	        (mu_d[0]->pr)[ii]=(res[0]->pr)[ii];

	}  /* ende des else-zweiges */

/*	aus fuzzy-zahl wird durch entsprechende methode scharfer wert 
	gemacht                 */
      
       
      
      } /* ende des j-schleife */

    } /* ende des i-blockes */

     
    OUT1=create_matrix(1,ilen,REAL);

    for(i=0;i<ilen;i++)
       (OUT1->pr)[i]=(mu_d[0]->pr)[i];
      
  free_matrix(mu_d[0]);
  free_matrix(mu_d[1]);
  free_matrix(mu_d[2]);
  free_matrix(mu_d[3]);
  free_matrix(res[0]);
  free_matrix(res[1]);
  return 0;
  } /* hier endet user-fcn */
