function [inset]=indef()
%INDEF		
%         [inset]=INDEF 
%         INDEF is a tool to design input-variables of a fuzzy-control
%         system.
%         INDEF returns a matrix 'inset', which contains the names of
%         the newly designed fuzzy variables and the abbreviations
%         of these variables.
%
%         Note, that the variable of type INSET can't be displayed
%         using SHOWSET - SHOWSET requires a complete set, i.e. the
%         output-variables must be linked to 'inset'.
%	         	
%         See also: OUTDEF

% Stephan Molt

clc;
TYP=computer;
TYP=TYP(1,1:2);
% pruefen, um welchen typ es sich handelt; wichtig fuer ascii-set
% Typ check, important for ascii-set
if(TYP=='PC')
  load c:\matlab\fuzzy\fuzzy1;
else
  a=' ';
  b='             FUZZY-CONTROLLER-DESIGN: Input-Variables';
  c=' ';
end
% darstellung der bildschirmmaske
disp(a);
disp(b);
disp(c);
leer=' ';
disp(leer)
k=input('Number of input-variables ');
disp(leer);
disp(leer);
txt1='Okay, so you have designed ';
txt2=num2str(k);
txt3=' input-variable(s). Let';
txt4=setstr(39);
txt5='s start now.';
txt=[txt1,txt2,txt3,txt4,txt5];
disp(txt);
disp(leer);

disp('Please input the name of the input-variable and then the abbreviation of it');

% vordefinitionen: bereitstellung der matrizen
% inizialize matrices
name=zeros(k,20);
abb=zeros(k,4);

% entsprechend der eingegebenen anzahl muessen jetzt namen definiert werden
% ask for names of variables
for i=1:1:k
	j=num2str(i);
	txt='. Variable : ';
	txt=[j,txt];
	s1=input(txt,'s');
	[void,len]=size(s1);
	if (~(len==20))
             s1=[s1,zeros(1,20-len)];
	end
	txt=['Abbreviation of ',j,'. Variable '];
	s2=input(txt,'s');
	[void,len]=size(s2);

	if(~(len==4))
	    s2=[s2,zeros(1,4-len)];
	end
	name(i,1:20)=s1;
	abb(i,1:4)=s2;	
end

% vorsicht: set ist nicht vom typ set; heisst bloss so
% Caution: inset is not of type set, its just the name
inset=[name,abb];


return

%------------------------------------------------------------------------------
%  Copyright (c) 1994, University of Stuttgart, IFR, All rights reserved.
%
%  Permission to use, copy, modify, and distribute this software and its
%  documentation for any non-commercial purpose without fee is hereby granted,
%  provided that the above copyright notice appears in all copies and that
%  both that copyright notice and this permission notice appear in
%  supporting documentation.
% 
%  THE IFR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
%  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
%  THE IFR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
%  ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
%  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
%  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
%  SOFTWARE.
%---------------------------------------------------------------------------
%  email:Postmaster@IFR.Luftfahrt.Uni-Stuttgart.DE

