function [extsetdesc]=editset(set,setdesc)

%EDITSET
%         [extsetdesc]=editset(set,setdesc) is a tool to edit the al-
%         ready designed setdescription-matrix 'setdesc'. EDITSET can 
%         be used if you want to change the range of the linguistic 
%         variables.
%         Before you use EDITSET, you must have designed a matrix of
%         type SETDESC by using MAKESET.
%         'set' is a matrix of type SET. 
%         The return-matrix 'extsetdesc' is the extended set-descrip-
%         tion-matrix.
%
%         (note: you can not use the ANALYSE-command in the fuzzy-con-
%         trol-system any longer if you want to work with your 
%         own extented set-description-matrix; you now have to 
%         use the EXT_ANA-command that can process matrices of 
%         type EXTSETDESC)
%
%         See also: MAKESET

% Stephan Molt 01-09-93

[zz1,ss1]=size(set);
% pruefen der argumente
if(ss1~=48) 
   error('the first argument must be of type SET');
end


n_in=abs(set(1,1));
n_out=abs(set(1,21));

insections=setdesc(1:n_in,1);
outsections=setdesc(1:n_out,4);

spalt=max(max(insections),max(outsections));
extsetdesc=zeros(n_in+n_out,spalt*4+1);

% schleife: jede einzelne fuzzy-zahl der eingangsgroessen wird abgefragt
% bei eingabe von return bleibt sie erhalten
for ii=1:1:n_in;
     clc;
     var=set(ii+1,1:20);	
     var=['Input-Variable (Nr.',num2str(ii),'): ',var];
     disp(var);
     sections=setdesc(ii,1);
     var=['(',num2str(sections),' Sections)'];
     disp(var);
     clear var;
     disp(' ');
     kstring=input('you want to make any changes in this set ? [y/n] ','s');
     disp(' ');

     if(kstring=='y' | kstring=='Y')
      c_flag=1;
     else
      c_flag=0;
     end

      string=lingus(sections);
      extsetdesc(ii,1)=sections;   

      x0=setdesc(ii,2);
      a=setdesc(ii,3);
      st=x0-a;
      h0=a/sections;
      anz1=sections-2;
      anz2=sections+1;
      aus=2*sections-2;

      j=0;

%     zuerst wird der vordere negative bereich untersucht
      for i=1:2:anz1;
      j=j+1;
      if(i==1)
     	f=[st,st+2*h0,0,h0,1];
      else
     	f=[st+i*h0,st+(i+1)*h0,h0,h0,1];
      end
      n=f(1);
      m=f(2);
      alpha=f(3);
      beta=f(4);

      if(c_flag==1)
        var=['section (',num2str(j),'): ',string(j,1:3)];
        disp(var);

        var=['f = [ ',num2str(n),' , ',num2str(m),' , ',num2str(alpha),' , ' num2str(beta),' ]'];
        disp(var);
	clear var;
        newfuzzy=input('new fuzzy-figure f = ');
	disp(' ');
        [ze,sp]=size(newfuzzy);
        if(ze==0 & sp==0)
%         alte werte beibehalten
        else 
	 if(ze==4)
	  newfuzzy=newfuzzy';
	 end
	 if(sp~=4) 
	  disp('A fuzzy-figure must have 1 row and 4 columns');
	 end
	 n=newfuzzy(1);
	 m=newfuzzy(2);
	 alpha=newfuzzy(3);
	 beta=newfuzzy(4);
	end
      end   %ende des c_flag-zweiges
	   
      extsetdesc(ii,j*4-2)=n;
      extsetdesc(ii,j*4-1)=m;
      extsetdesc(ii,j*4)=alpha;
      extsetdesc(ii,j*4+1)=beta;

      end   %ende der i-schleife

%     dann wird die null untersucht
      j=j+1;
      f=[x0,x0,h0,h0,1];      
      n=f(1);
      m=f(2);
      alpha=f(3);
      beta=f(4);

      if(c_flag==1)
        var=['section (',num2str(j),'): ','ZE'];
        disp(var);

        var=['f = [ ',num2str(n),' , ',num2str(m),' , ',num2str(alpha),' , ' num2str(beta),' ]'];
        disp(var);
        clear var;
	newfuzzy=input('new fuzzy-figure f = ');
	disp(' ');
        [ze,sp]=size(newfuzzy);
        if(ze==0 & sp==0)
%         alte werte beibehalten
        else 
	 if(ze==4)
	  newfuzzy=newfuzzy';
	 end
	 if(sp~=4) 
	  disp('A fuzzy-figure must have 1 row and 4 columns');
	 end
	 n=newfuzzy(1);
	 m=newfuzzy(2);
	 alpha=newfuzzy(3);
	 beta=newfuzzy(4);
	end
      end    %ende des c_flag-zweiges

      extsetdesc(ii,j*4-2)=n;
      extsetdesc(ii,j*4-1)=m;
      extsetdesc(ii,j*4)=alpha;
      extsetdesc(ii,j*4+1)=beta;


%    als letztes wird der hintere, positive bereich geprft;

      for i=anz2:2:aus;
       j=j+1;
       if(i==aus)
        f=[st+i*h0,st+(i+2)*h0,h0,0,1];
       else
	f=[st+i*h0,st+(i+1)*h0,h0,h0,1];
       end

       n=f(1);
       m=f(2);
       alpha=f(3);
       beta=f(4);

       if(c_flag==1)
         var=['section (',num2str(j),'): ',string(j,1:3)];
         disp(var);

         var=['f = [ ',num2str(n),' , ',num2str(m),' , ',num2str(alpha),' , ' num2str(beta),' ]'];
         disp(var);
         clear var;
	 newfuzzy=input('new fuzzy-figure f = ');
	 disp(' '); 
         [ze,sp]=size(newfuzzy);
         if(ze==0 & sp==0)
%         alte werte beibehalten
         else 
	  if(ze==4)
	   newfuzzy=newfuzzy';
	  end
	  if(sp~=4) 
	   disp('A fuzzy-figure must have 1 row and 4 columns');
	  end
	  n=newfuzzy(1);
	  m=newfuzzy(2);
	  alpha=newfuzzy(3);
	  beta=newfuzzy(4);
	 end
       end     %ende des c_flag-zweiges

       extsetdesc(ii,j*4-2)=n;
       extsetdesc(ii,j*4-1)=m;
       extsetdesc(ii,j*4)=alpha;
       extsetdesc(ii,j*4+1)=beta;

      end % ende der i-schleife


end  %ende der ii-schleife fr nin


% analog wie oben, hier fuer ausgangs-(steuer-)groessen
for ii=1:1:n_out
     clc;
     var=set(ii+1,25:44);	
     var=['Output-Variable (Nr.',num2str(ii),'): ',var];
     sections=setdesc(ii,4);
     var=[var,'    (',num2str(sections),' Sections)'];
     disp(var);
     disp(' ');
     clear var;
     kstring=input('you want to make any changes in this set ? [y/n] ','s');
     disp(' ');

     if(kstring=='y' | kstring=='Y')
      c_flag=1;
     else
      c_flag=0;
     end

      string=lingus(sections);
      extsetdesc(ii+n_in,1)=sections;   

      x0=setdesc(ii,5);
      a=setdesc(ii,6);
      st=x0-a;
      h0=a/sections;
      anz1=sections-2;
      anz2=sections+1;
      aus=2*sections-2;
      j=0;

%     zuerst wird der vordere negative bereich untersucht
      for i=1:2:anz1;
      j=j+1;
      if(i==1)
     	f=[st,st+2*h0,0,h0,1];
      else
     	f=[st+i*h0,st+(i+1)*h0,h0,h0,1];
      end
      n=f(1);
      m=f(2);
      alpha=f(3);
      beta=f(4);

      if(c_flag==1)
        var=['section (',num2str(j),'): ',string(j,1:3)];
        disp(var);

        var=['f = [ ',num2str(n),' , ',num2str(m),' , ',num2str(alpha),' , ' num2str(beta),' ]'];
        disp(var);
        clear var;
	newfuzzy=input('new fuzzy-figure f = ');
	disp(' ');
        [ze,sp]=size(newfuzzy);
        if(ze==0 & sp==0)
%        alte werte beibehalten
	else 
	 if(ze==4)
	  newfuzzy=newfuzzy';
	 end
	 if(sp~=4) 
	  disp('A fuzzy-figure must have 1 row and 4 columns');
	 end
	 n=newfuzzy(1);
	 m=newfuzzy(2);
	 alpha=newfuzzy(3);
	 beta=newfuzzy(4);
	end
      end    %ende des c_flag-zweiges
	   
      extsetdesc(ii+n_in,j*4-2)=n;
      extsetdesc(ii+n_in,j*4-1)=m;
      extsetdesc(ii+n_in,j*4)=alpha;
      extsetdesc(ii+n_in,j*4+1)=beta;

      end   %ende der i-schleife

%     dann wird die null untersucht
      j=j+1;
      f=[x0,x0,h0,h0,1];      
      n=f(1);
      m=f(2);
      alpha=f(3);
      beta=f(4);

      if(c_flag==1)
        var=['section (',num2str(j),'): ','ZE'];
        disp(var);

        var=['f = [ ',num2str(n),' , ',num2str(m),' , ',num2str(alpha),' , ' num2str(beta),' ]'];
        disp(var);
	clear var;
	newfuzzy=input('new fuzzy-figure f = ');
	disp(' ');
        [ze,sp]=size(newfuzzy);
        if(ze==0 & sp==0)
%        alte werte beibehalten
        else 
	 if(ze==4)
	  newfuzzy=newfuzzy';
	 end
	 if(sp~=4) 
	  disp('A fuzzy-figure must have 1 row and 4 columns');
	 end
	 n=newfuzzy(1);
	 m=newfuzzy(2);
	 alpha=newfuzzy(3);
	 beta=newfuzzy(4);
	end
      end   %ende des c_flag-zweiges

      extsetdesc(ii+n_in,j*4-2)=n;
      extsetdesc(ii+n_in,j*4-1)=m;
      extsetdesc(ii+n_in,j*4)=alpha;
      extsetdesc(ii+n_in,j*4+1)=beta;


%    als letztes wird der hintere, positive bereich geprft;

      for i=anz2:2:aus;
       j=j+1;
       if(i==aus)
        f=[st+i*h0,st+(i+2)*h0,h0,0,1];
       else
	f=[st+i*h0,st+(i+1)*h0,h0,h0,1];
       end

       n=f(1);
       m=f(2);
       alpha=f(3);
       beta=f(4);

       if(c_flag==1)
         var=['section (',num2str(j),'): ',string(j,1:3)];
         disp(var);

         var=['f = [ ',num2str(n),' , ',num2str(m),' , ',num2str(alpha),' , ' num2str(beta),' ]'];
	 disp(var);
	 clear var;
         newfuzzy=input('new fuzzy-figure f = ');
	 disp(' ');
         [ze,sp]=size(newfuzzy);
         if(ze==0 & sp==0)
%         alte werte beibehalten
         else 
	  if(ze==4)
	   newfuzzy=newfuzzy';
	  end
	  if(sp~=4) 
	   disp('A fuzzy-figure must have 1 row and 4 columns');
	  end
	  n=newfuzzy(1);
	  m=newfuzzy(2);
	  alpha=newfuzzy(3);
	  beta=newfuzzy(4);
	 end
       end  %ende des c_flag-zweiges

       extsetdesc(ii+n_in,j*4-2)=n;
       extsetdesc(ii+n_in,j*4-1)=m;
       extsetdesc(ii+n_in,j*4)=alpha;
       extsetdesc(ii+n_in,j*4+1)=beta;

      end % ende der i-schleife
    
end   %ende der ii-schleife fr nout



%variablenliste
%ii, i, j,     	- laufvariable
%newfuzzy   	- neue, eingegebene fuzzy-zahl
%c_flag		- 1: nderungen, 0: set bleibt
%n,m,alpha,beta	- fuzzy-zahl
%var, kstring	- string-variablen
%f		- fuzzy-zahl
%ze, sp		- zeilen und spalten von newfuzzy


return

%------------------------------------------------------------------------------
%  Copyright (c) 1994, University of Stuttgart, IFR, All rights reserved.
%
%  Permission to use, copy, modify, and distribute this software and its
%  documentation for any non-commercial purpose without fee is hereby granted,
%  provided that the above copyright notice appears in all copies and that
%  both that copyright notice and this permission notice appear in
%  supporting documentation.
% 
%  THE IFR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
%  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
%  THE IFR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
%  ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
%  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
%  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
%  SOFTWARE.
%---------------------------------------------------------------------------
%  email:Postmaster@IFR.Luftfahrt.Uni-Stuttgart.DE


