function [rule]=editrule_pc(rule,rule_nr,set,setdesc)

%EDITRULE     edit the rules of an alreay dsigned fuzzy-control-system
%
%         [rule]=EDITRULE_PC(rule,rule_nr,set,setdesc) is a subroutine
%         to edit the rules of an alreay dsigned fuzzy-control-system. 
%         'set' is a matrix of type SET and 'setdesc' is the set-descrip-
%         tion-matrix; to obtain those matrices use the MAKESET- and the 
%         OUTDEF-command. 
%         'rule' contains the already designed rules of the fuzzy-con-
%         troller and 'rule_nr' is the number of the rule you want to
%         change. 
%         If you want to add a completely new rule, call EDITRULE and 
%         assign 'rule_nr ' a negative value.
%
%         See also MAKESET, INDEF, OUTDEF, RULES
%
%         (note: there is no tool in this toolbox that provides the
%         facility to show a certain rule - you'll have to use
%         this command if you just want to look at a rule)

if(nargin~=4)
  error('wrong number of arguments - EDITRULE requires four arguments');
end

[zeil,spalt]=size(rule);
[zz1,ss1]=size(set);
if(ss1~=48)
  error('the third argument must be of type SET');
end
max_rule=spalt/3;
n_in=abs(set(1,1));
n_out=abs(set(1,21));
st=rule_nr*3-2;
en=rule_nr*3;



if(rule_nr>0)
  if(rule_nr<=max_rule) 

     vor=rule(1:zeil,1:st-1);
     insert=rule(1:zeil,st:en);
     nach=rule(1:zeil,en+1:spalt);

     [yout,rows]=dsp2(rule_nr,set,insert,setdesc);
     [insert]=entry(yout,insert,setdesc);
   else
     error('rule-index exceeds the maximum number of rules')
  end

  rule=[vor,insert,nach];

else
  
  [yout,rows]=dsp(max_rule+1,set); 
  reg=init(rows,n_in,n_out);
  [reg]=entry(yout,reg,setdesc);
  [rule]=[rule,reg];

end

