function [regel]=designrule(set,sd)

%DESIGNRULE
%         [rule]=DESIGNRULE(set,setdesc) is a subroutine to design the 
%         rules for a fuzzy-control-system. 'set' is a matrix of type
%         SET and 'setdesc' is the set-description matrix; to obtain
%         those matrices use the MAKESET- and the OUTDEF-command. Matrix
%         'rules' contains all designed rules of the fuzzy-controller
%         and may later be used for evaluation in this system.
%
%         (note: if you have designed your own matrix of type EXSETDESC
%         it's still possible to use this command to design the
%         rules; note also, that 'setdesc' must then also be of
%         type SETDESC and not of type EXTSETDESC)
%
%         See also MAKESET, INDEF, OUTDEF

% Stephan Molt 01-09-03

clg;
nr=1;
makerule2(set,sd,nr);
while 1==1
   
  k=input('add another rule? [y/n] ','s');
  if k=='y' 
     nr=nr+1;
     
     makerule2(set,sd,nr);
  elseif k=='n'
     load f__temp2
         
     regel=rule1;
     break;
   end
end



return

%------------------------------------------------------------------------------
%  Copyright (c) 1994, University of Stuttgart, IFR, All rights reserved.
%
%  Permission to use, copy, modify, and distribute this software and its
%  documentation for any non-commercial purpose without fee is hereby granted,
%  provided that the above copyright notice appears in all copies and that
%  both that copyright notice and this permission notice appear in
%  supporting documentation.
% 
%  THE IFR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
%  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
%  THE IFR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
%  ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
%  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
%  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
%  SOFTWARE.
%---------------------------------------------------------------------------
%  email:Postmaster@IFR.Luftfahrt.Uni-Stuttgart.DE

