/*****************************************************************************/
/*  File - FuzzyPrn.c                                                            */
/*                                                                           */
/*  Description: This file contains the code for driving a fuzzy logic       */
/*  expert fan controller.                                                   */
/*                                                                           */
/*  This program will generate a 2-dimensional array of numbers,             */
/*  representing the control surface.. This surface may be displayed using   */
/*  the 'mesh' command in MatLab..                                           */
/*                                                                           */
/*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

/* The following defines the data sets used for 
*  driving the Fuzzy Logic Expert FAN Controller
*
*      T[] - universal discourse for temperature
*      H[] - universal discourse for humidity
*/
#define N_SET 17           /* N_SET defines the number of fuzzy set values   */
float t[]={40, 45, 50, 55, 60, 65, 70, 75, 80, 85, 90, 95,100,105,110,115,120};
float h[]={20, 25, 30, 35, 40, 45, 50, 55, 60, 65, 70, 75, 80, 85, 90, 95,100};

/* InitController()
*
*  InitController() is used to simulate the startup routines that would
*  be performed if this was an actual controller.
*
*  Designed by: Henry Hurdon      Date: Mar.  15, 1993
*  Reviewed by: ................. Date: ..............
*  Modified by: Henry Hurdon      Date: Mar.  15, 1993
*/
int h_inc = 0;
int t_inc = 0;

void InitController(void)
{
 /* empty "stub" procedure */
}


/* GetInputs()
*
*  GetInputs() is used to simulate the reading of the input variables for
*  the fuzzy logic controller.
*
*  Designed by: Henry Hurdon      Date: Mar.  15, 1993
*  Reviewed by: ................. Date: ..............
*  Modified by: Henry Hurdon      Date: Mar.  15, 1993
*/
void GetInputs(float *Uo, float *Vo)
{
   *Uo = t[t_inc];
   *Vo = h[h_inc];
}

/* SetOutput()
*
*  SetOutput() is used to simulate the setting of the output variable for
*  the fuzzy logic controller.
*
*  Designed by: Henry Hurdon      Date: Mar.  15, 1993
*  Reviewed by: ................. Date: ..............
*  Modified by: Henry Hurdon      Date: Mar.  15, 1993
*/
void SetOutput(float Yo)
{
   if (h_inc == (N_SET-1)) {
      printf("% 8.2f\n", Yo);
      h_inc = 0;

      if (t_inc == (N_SET-1)) {
        exit(0);
      } else {
        t_inc++;
      }
   } else {
      printf("% 8.2f", Yo);
      h_inc++;
   }
}
