%	To be called from learing_list.m.

%	Copyright (c) 1993 Jyh-Shing Roger Jang, U. C. Berkeley
%	jang@eecs.berkeley.edu
%	(Tested on Matlab version 4.0a, HP workstation)
%	Permission is granted to modify and re-distribute this code
%	in any manner as long as this notice is preserved.
%	All standard disclaimers apply.

%	7-9-93.

global Data Plothandle H1 H2 Count Text Learning_mode
set(gcf, 'position', [12 12 560 960]);
Count = 1;
x = linspace(-1,1,101)';
y = 0.6*sin(pi*x) + 0.3*sin(3*pi*x) + 0.1*sin(5*pi*x);
Data = [x y];

mf_n = 3;
in_n = 1;
% set up initial parameters
a = (max(x) - min(x))/(2*mf_n - 2)*ones(1, mf_n);;
b = 4*ones(1, mf_n);;
c = linspace(min(x), max(x), mf_n);
premise_para = [a; b; c];
consequent_para = zeros(mf_n*(in_n+1), 1); 
if Learning_mode == 1,
	init_para = [premise_para(:); consequent_para];
elseif Learning_mode == 2,
	init_para = premise_para(:);
else
	error('Invalid value for Learning_mode.');
end

% initial MF plots
mf1 = bell(x, init_para(1), init_para(2), init_para(3));
mf2 = bell(x, init_para(4), init_para(5), init_para(6));
mf3 = bell(x, init_para(7), init_para(8), init_para(9));
mf = [mf1 mf2 mf3];
subplot(311); H1 = plot(x,mf);
axis([min(x) max(x) 0 1]);
set(H1, 'erasemode', 'background');
title('MF''s (weights)');

% initial output plots
if Learning_mode == 1,
	p1 = init_para(10); q1 = init_para(11);
	p2 = init_para(12); q2 = init_para(13);
	p3 = init_para(14); q3 = init_para(15);
elseif Learning_mode == 2,
	p1 = consequent_para(1); q1 = consequent_para(2);
	p2 = consequent_para(3); q2 = consequent_para(4);
	p3 = consequent_para(5); q3 = consequent_para(6);
else
	error('Invalid value for Learning_mode.');
end
out1 = p1*x + q1;
out2 = p2*x + q2;
out3 = p3*x + q3;
maxi = max(max(mf1, mf2), mf3);
index1 = find(mf1 ~= maxi);
tmp1 = out1; tmp1(index1) = NaN*zeros(size(index1));
index2 = find(mf2 ~= maxi);
tmp2 = out2; tmp2(index2) = NaN*zeros(size(index2));
index3 = find(mf3 ~= maxi);
tmp3 = out3; tmp3(index3) = NaN*zeros(size(index3));
tmp = [tmp1 tmp2 tmp3];
subplot(312); H2 = plot(x, tmp);
set(H2, 'erasemode', 'xor');
title('output of each rule');

%	Let's plot this data.
subplot(313); plot(x,y,'co','EraseMode','none')
xlabel('');
Text = get(gca, 'xlabel'); set(Text, 'EraseMode', 'xor');
axis([-1 1 -1 1])
hold on
title('Input data')

Plothandle = plot(x,y,'r-','EraseMode','xor');

pp;

trace = 0;
tol = 10;
para = fmins('fis_fun',init_para,[trace tol]);
%para = fmins('fis_fun',init_para);

hold off
%s = ['lambda = fmins(''fis_fun'',[1 0]'',[0 .1]);'];
%uicontrol('Units','normal','Position',[.2 .01 .1 .06],'String','Again','callback',s)
