%	To be called from fit_fis.m

%	Copyright (c) 1993 Jyh-Shing Roger Jang, U. C. Berkeley
%	jang@eecs.berkeley.edu
%	(Tested on Matlab version 4.0a, HP workstation)
%	Permission is granted to modify and re-distribute this code
%	in any manner as long as this notice is preserved.
%	All standard disclaimers apply.

%	7-4-93.

function rmse = fit_fun(para)

global Data Plothandle H1 H2 Count Text Learning_mode
x = Data(:,1);
y = Data(:,2);

a1 = para(1); b1 = para(2); c1 = para(3);
a2 = para(4); b2 = para(5); c2 = para(6);
a3 = para(7); b3 = para(8); c3 = para(9);
mf1 = bell(x, a1, b1, c1);
mf2 = bell(x, a2, b2, c2);
mf3 = bell(x, a3, b3, c3);
set(H1(1,1), 'ydata', mf1);
set(H1(2,1), 'ydata', mf2);
set(H1(3,1), 'ydata', mf3);

weight_total = mf1 + mf2 + mf3;
normalized_w1 = mf1./weight_total;
normalized_w2 = mf2./weight_total;
normalized_w3 = mf3./weight_total;
normalized_w = [normalized_w1 normalized_w2 normalized_w3];

if Learning_mode == 1,
	p1 = para(10); q1 = para(11);
	p2 = para(12); q2 = para(13);
	p3 = para(14); q3 = para(15);
elseif Learning_mode == 2,
	A = [normalized_w1.*x normalized_w1 normalized_w2.*x normalized_w2 normalized_w3.*x normalized_w3];
	consequent_para = A\y;
	p1 = consequent_para(1); q1 = consequent_para(2);
	p2 = consequent_para(3); q2 = consequent_para(4);
	p3 = consequent_para(5); q3 = consequent_para(6);
else
	error('Invalid value for Learning_mode.');
end
out1 = p1*x + q1;
out2 = p2*x + q2;
out3 = p3*x + q3;
maxi = max(max(mf1, mf2), mf3);
index1 = find(mf1 ~= maxi);
tmp1 = out1; tmp1(index1) = NaN*zeros(size(index1));
index2 = find(mf2 ~= maxi);
tmp2 = out2; tmp2(index2) = NaN*zeros(size(index2));
index3 = find(mf3 ~= maxi);
tmp3 = out3; tmp3(index3) = NaN*zeros(size(index3));
set(H2(1,1), 'ydata', tmp1);
set(H2(2,1), 'ydata', tmp2);
set(H2(3,1), 'ydata', tmp3);

normalized_out1 = out1.*normalized_w1;
normalized_out2 = out2.*normalized_w2;
normalized_out3 = out3.*normalized_w3;
normalized_out = [normalized_out1 normalized_out2 normalized_out3];
overall_out = normalized_out1 + normalized_out2 + normalized_out3;

rmse = norm(overall_out-y)/sqrt(length(y));
text = sprintf('Evaluation count: %d        RMSE: %.4f', Count, rmse);
set(Text, 'string', text);
set(Plothandle,'ydata',overall_out)
drawnow
Count = Count + 1;
