//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Weibull.h,v 0.22 1994/07/22 09:20:28 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNWeibull --- CNWeibull distributed random numbers
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************
 * original Copyright:
 * -------------------
 * Copyright (C) 1988 Free Software Foundation
 *    written by Dirk Grunwald (grunwald@cs.uiuc.edu)
 * 
 * This file is part of the GNU C++ Library.  This library is free
 * software; you can redistribute it and/or modify it under the terms of
 * the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This library is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 **EHEADER********************************************************************/


#ifndef __Weibull_h
#define __Weibull_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Random.h>		// Base class

extern CNClassDesc CN_WEIBULL;	// CNClass CNWeibull description



/*
 * The class CNWeibull
 */

class CNWeibull : public CNRandom
{
protected:
    double pAlpha;
    double pInvAlpha;
    double pCNBeta;

    void setState();

public:
    double alpha();
    double alpha(double x);
    double beta();
    double beta(double x);

    virtual double operator()();

    /***** Constructors ******************************************************/
public:
    CNWeibull();   				// Default constructor
    CNWeibull(CNParam *param); 			// CNParam constructor
    CNWeibull(double alpha, double beta, CNRNG *gen);

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_WEIBULL;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_WEIBULL ? TRUE : CNRandom::is_a(desc);
    };
        
    static CNWeibull *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNWeibull *)obj;
#   else
	return (CNWeibull *)( !obj || obj->is_a(CN_WEIBULL)
	       ? obj : fatal_type(obj->class_desc(), CN_WEIBULL) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNWeibull(param) : new CNWeibull; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};



inline void CNWeibull::setState() {
    pInvAlpha = 1.0 / pAlpha;
}
    
inline CNWeibull::CNWeibull(double alpha, double beta,  CNRNG *gen)
    : CNRandom(gen)
{
    pAlpha = alpha;
    pCNBeta = beta;
    setState();
}

inline CNWeibull::CNWeibull()
	 : CNRandom((CNRNG*)NIL)
{
    pAlpha = 0;
    pInvAlpha = 0;
    pCNBeta = 0;
}    

inline CNWeibull::CNWeibull(CNParam *param)
	 : CNRandom((CNRNG*)NIL)
{
    pAlpha = 0;
    pInvAlpha = 0;
    pCNBeta = 0;
}    

inline double CNWeibull::alpha() { return pAlpha; }

inline double CNWeibull::alpha(double x) {
    double tmp = pAlpha;
    pAlpha = x;
    setState();
    return tmp;
}

inline double CNWeibull::beta() { return pCNBeta; };

inline double CNWeibull::beta(double x) {
    double tmp = pCNBeta;
    pCNBeta = x;
    return tmp;
};


#endif /**__Weibull_h**/
