//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Select.h,v 0.22 1994/07/22 09:21:16 cncl-adm Exp cncl-adm $
 *
 * Class: CNSelect --- Class interface to select(2) system call
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __CNSelect_h
#define __CNSelect_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>
#include <CNCL/Object.h>		// Base class

#include <memory.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>			// libg++: include select() prototype

extern CNClassDesc CN_SELECT;	// Class CNSelect description


/*
 * The class CNSelect
 */

class CNSelect : public CNObject
{
  public:
    // Add/delete/test file descriptor - read set
    void add_read(int fd)	{ FD_SET(fd, &rdfds); }
    void del_read(int fd)	{ FD_CLR(fd, &rdfds); }
    bool test_read(int fd)	{ return FD_ISSET(fd, &rdfds) != 0; }
    // Add/delete/test file descriptor - write set
    void add_write(int fd)	{ FD_SET(fd, &wrfds); }
    void del_write(int fd)	{ FD_CLR(fd, &wrfds); }
    bool test_write(int fd)	{ return FD_ISSET(fd, &wrfds) != 0; }
    // Add/delete/test file descriptor - except set
    void add_except(int fd)	{ FD_SET(fd, &exfds); }
    void del_except(int fd)	{ FD_CLR(fd, &exfds); }
    bool test_except(int fd)	{ return FD_ISSET(fd, &exfds) != 0; }

    // Select call
    bool select();
    bool select(long sec, long usec);
    
    // Private members
  private:
    fd_set rdfds, wrfds, exfds;			// Set of file descriptors

    /***** Constructors ******************************************************/
  public:
    CNSelect();
    CNSelect(CNParam *param);
    CNSelect(int fd);
    
    /***** Member functions required by CNCL *********************************/
  public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_SELECT;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_SELECT ? TRUE : CNObject::is_a(desc);
    };
        
    static CNSelect *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNSelect *)obj;
#   else
	return (CNSelect *)( !obj || obj->is_a(CN_SELECT)
	       ? obj : fatal_type(obj->class_desc(), CN_SELECT) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNSelect(param) : new CNSelect; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__CNSelect_h**/
