//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: FRuleBase.h,v 0.22 1994/07/22 09:21:33 cncl-adm Exp cncl-adm $
 *
 * Class: CNFRuleBase --- Rule base and Fuzzy inference engine
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __CNFRuleBase_h
#define __CNFRuleBase_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>
#include <CNCL/Named.h>		// Base class
#include <CNCL/FRule.h>
#include <CNCL/ArrayObject.h>

extern CNClassDesc CN_FRULEBASE;	// Class CNFRuleBase description


/*
 * The class CNFRuleBase
 */

class CNFRuleBase : public CNNamed
{
public:
    enum { DEF_RESOLUTION = 101 };	// = 100 increments

    void add_rule   (CNFRule *rule);	// Add rule to base
    void add_rule   (CNFRule &rule);	// Add rule to base
    void add_in_var (CNFVar *rule);	// Add input var to base
    void add_in_var (CNFVar &rule);	// Add input var to base
    void add_out_var(CNFVar *rule);	// Add output to base
    void add_out_var(CNFVar &rule);	// Add output to base

    int get_n_rules() const;		// Get # of rules
    int get_n_in_vars() const;		// Get # of input vars
    int get_n_out_vars() const;		// Get # of output vars

    int resolution() const;		// Return output fuzzy set resolution

					// Compute inference set
    void inference(CNFVar *var, CNFSet *set, double match, CNFSetArray &res);
					// Compute output set for variable
    void evaluate (CNFVar *var, CNFSetArray &res);

    void aggregate_all();		// Aggregate all rules
    void evaluate_all();		// Evaluate all variables
    void defuzzy_all();			// Defuzzify all output variables

    void debug_rules(ostream &strm=cout, int lvl=0);
    
    // Private members
private:
    //        Aggregation operator
    // FIXME: Inference operator
    //        Accumulation operator
    CNArrayObject rules;		// The rules
    CNArrayObject in_vars;		// Input variables
    CNArrayObject out_vars;		// Output variables
    int nsteps;				// Resolution (n) of output fuzzy sets

    /***** Constructors ******************************************************/
public:
    CNFRuleBase()
	: CNNamed(""),
	  rules(0), in_vars(0), out_vars(0), nsteps(DEF_RESOLUTION) {}
    CNFRuleBase(CNStringR name)
	: CNNamed(name),
	  rules(0), in_vars(0), out_vars(0), nsteps(DEF_RESOLUTION) {}
    CNFRuleBase(CNParam *param)
	: CNNamed(""),
	  rules(0), in_vars(0), out_vars(0), nsteps(DEF_RESOLUTION) {}

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_FRULEBASE;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_FRULEBASE ? TRUE : CNObject::is_a(desc);
    };
        
    static CNFRuleBase *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNFRuleBase *)obj;
#   else
	return (CNFRuleBase *)( !obj || obj->is_a(CN_FRULEBASE)
	       ? obj : fatal_type(obj->class_desc(), CN_FRULEBASE) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNFRuleBase(param) : new CNFRuleBase; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


#endif /**__CNFRuleBase_h**/
