//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EventHandler.h,v 0.22 1994/07/22 09:21:05 cncl-adm Exp cncl-adm $
 *
 * CNClass: CNEventHandler --- Abstract base class for event handler
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __EventHandler_h
#define __EventHandler_h


#include <CNCL/Named.h>		// Base class
#include <CNCL/Event.h>

extern CNClassDesc CN_EVENTHANDLER;	// CNClass CNEventHandler description


class CNEventScheduler;



/*
 * The class CNEventHandler
 */

class CNEventHandler : public CNNamed
{
    friend class CNEventScheduler;
    
  public:	/***** Constructors ******************************************/
    CNEventHandler()
	: CNNamed("noname"), ev_state(0), ev_scheduler(NIL) {}
    CNEventHandler(CNParam *param)
	: CNNamed("noname"), ev_state(0), ev_scheduler(NIL) {}
    CNEventHandler(CNStringR name)
	: CNNamed(name)    , ev_state(0), ev_scheduler(NIL) {}


  protected:	/***** Protected interface ***********************************/
    // This function MUST be defined in the derived classes
    virtual void event_handler(const CNEvent *ev) = 0;

    // Get scheduler which called the event handler
    CNEventScheduler *scheduler() const
    {
	return ev_scheduler;
    }

    // Get/set state
    int state() const
    {
	return ev_state;
    }

    int state(int new_state)
    {
	int old = ev_state;
	ev_state = new_state;
	return old;
    }
    
    int get_state() const
    {
	return ev_state;
    }

    int set_state(int new_state)
    {
	int old = ev_state;
	ev_state = new_state;
	return old;
    }

    // Current simulation time
    CNSimTime now() const
    {
	return ev_now;
    }

    // CNEvent sending functions
    CNEventID send_event(CNEvent *ev);
    CNEventID send(CNEvent *ev);
    CNEventID send_now(CNEvent *ev);
    CNEventID send_delay(CNEvent *ev, double dt);
    void delete_event(CNEventID id);
    void delete_events(CNEventHandler *evh = NIL);
    
  private:	/***** Internal private members ******************************/
    int ev_state;			// CNEvent handler state
    CNSimTime ev_now;			// Current simulation time
    CNEventScheduler *ev_scheduler;	// Scheduler which called event handler
    void process_event(CNEventScheduler *sched,
		       const CNSimTime t, CNEvent *ev);
    					// Called by event scheduler

  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_EVENTHANDLER; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_EVENTHANDLER ? TRUE : CNNamed::is_a(desc); }
        
    static CNEventHandler *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNEventHandler *)obj;
#   else
	return (CNEventHandler *)( !obj || obj->is_a(CN_EVENTHANDLER)
	       ? obj : fatal_type(obj->class_desc(), CN_EVENTHANDLER) );
#   endif
    }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__EventHandler_h**/
