//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EZDTextWin.h,v 0.22 1994/07/22 09:21:19 cncl-adm Exp cncl-adm $
 *
 * Class: EZDTextWin --- ezd window for easy text display
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __EZDTextWin_h
#define __EZDTextWin_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/EZD.h>		// Base class
#include <CNCL/EZDWindow.h>
#include <CNCL/EZDDrawing.h>

extern CNClassDesc CN_EZDTEXTWIN;	// Class EZDTextWin description



#define EZD_TEXTWIN_DEF_FONT	"9x15"


/*
 * The class EZDTextWin
 */

class EZDTextWin : public EZD
{
  public:	/***** Constructors ******************************************/
    enum { ROWS=24, COLS=80, INCX=9, INCY=15 };

    EZDTextWin(CNParam *param)
	: EZD("textwin"), win(NIL), draw(NIL),
 	  w_rows(ROWS), w_cols(COLS), w_incx(INCX), w_incy(INCY),
	  w_font(EZD_TEXTWIN_DEF_FONT), w_color("")
					{ initialize( name(), -1, -1 ); }
    EZDTextWin(int r=ROWS, int c=COLS, int ix=INCX, int iy=INCY)
	: EZD("textwin"), win(NIL), draw(NIL),
 	  w_rows(ROWS), w_cols(COLS), w_incx(INCX), w_incy(INCY),
	  w_font(EZD_TEXTWIN_DEF_FONT), w_color("")
					{ initialize( name(), -1, -1 ); }
    EZDTextWin(int r, int c, int ix, int iy, CNStringR f)
	: EZD("textwin"), win(NIL), draw(NIL),
	  w_rows(r), w_cols(c), w_incx(ix), w_incy(iy),
	  w_font(f), w_color("")
					{ initialize( name(), -1, -1 ); }
    EZDTextWin(CNStringR n, int r=ROWS, int c=COLS, int ix=INCX, int iy=INCY)
	: EZD(n), win(NIL), draw(NIL),
	  w_rows(r), w_cols(c), w_incx(ix), w_incy(iy),
	  w_font(EZD_TEXTWIN_DEF_FONT), w_color("")
					{ initialize( name(), -1, -1 ); }
    EZDTextWin(CNStringR n, int r, int c, int ix, int iy, CNStringR f)
	: EZD(n), win(NIL), draw(NIL),
	  w_rows(r), w_cols(c), w_incx(ix), w_incy(iy),
	  w_font(f), w_color("")
					{ initialize( name(), -1, -1 ); }
    EZDTextWin(CNStringR n, CNStringR t, 
	       int r=ROWS, int c=COLS, int ix=INCX, int iy=INCY)
	: EZD(n), win(NIL), draw(NIL),
	  w_rows(r), w_cols(c), w_incx(ix), w_incy(iy),
	  w_font(EZD_TEXTWIN_DEF_FONT), w_color("")
					{ initialize( t, -1, -1 ); }
    EZDTextWin(CNStringR n, CNStringR t,
	       int r, int c, int ix, int iy, CNStringR f)
	: EZD(n), win(NIL), draw(NIL),
	  w_rows(r), w_cols(c), w_incx(ix), w_incy(iy),
	  w_font(f), w_color("")
					{ initialize( t, -1, -1 ); }

    ~EZDTextWin();
    

  public:	/***** Public interface **************************************/
    int width () const { return w_width;  }
    int height() const { return w_height; }
    int cols  () const { return w_cols;   }
    int rows  () const { return w_rows;   }
    int incx  () const { return w_incx;   }
    int incy  () const { return w_incy;   }

    int row_to_y(int r) const { return r*w_incy; }
    int col_to_x(int c) const { return c*w_incx; }

    void clear();
    void clear(int r, int c, int l);
    void set();					// Set drawing to diag win
    void hline(int r, int c, int l);
    void vline(int r, int c, int l);
    void add(int r, int c, CNStringR s);	// Draw text at row r, col c
    void add(int r, int c, CNStringR s, CNStringR f);

    
  private:	/***** Internal private members ******************************/
    EZDWindow *win;			// Window used
    EZDDrawing *draw;			// Drawing used
    int w_width, w_height;		// Width, height of window
    int w_rows, w_cols, w_incx, w_incy;
    CNString w_font;
    CNString w_color;
    
    void initialize(CNStringR title, int x, int y);

    void clear_i(int r, int c, int l);
    
  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_EZDTEXTWIN; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_EZDTEXTWIN ? TRUE : EZD::is_a(desc); }
        
    static EZDTextWin *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (EZDTextWin *)obj;
#   else
	return (EZDTextWin *)( !obj || obj->is_a(CN_EZDTEXTWIN)
	       ? obj : fatal_type(obj->class_desc(), CN_EZDTEXTWIN) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new EZDTextWin(param) : new EZDTextWin; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__EZDTextWin_h**/
