//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EZDBlock.h,v 0.22 1994/07/22 09:21:19 cncl-adm Exp cncl-adm $
 *
 * Class: EZDBlock --- Block with small rectangles for bit display
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __EZDBlock_h
#define __EZDBlock_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/EZDObject.h>		// Base class

extern CNClassDesc CN_EZDBLOCK;	// Class EZDBlock description


/*
 * The class EZDBlock
 */

class EZDBlock : public EZDObject
{
 public:	/***** Constructors ******************************************/
    EZDBlock()
	: EZDObject("block", 0, 0), 
	  color_on("black"), color_off("white"), b_colors(NIL) {}
    EZDBlock(CNParam *param)
	: EZDObject("block", 0, 0), 
	  color_on("black"), color_off("white"), b_colors(NIL) {}
    EZDBlock(const CNString &name, int x, int y, int r, int c, int b)
	: EZDObject(name, x, y), 
	  color_on("black"), color_off("white"), b_colors(NIL)
    { initialize(r, c, b); }

    ~EZDBlock()
    { if(b_colors) delete [] b_colors; }

  public:	/***** Public interface **************************************/
    virtual void redraw();

    void on(int b);				// Turn bit on
    void off(int b);				// Turn bit off

  private:	/***** Internal private members ******************************/
    enum { FRAME=1 };

    CNString color_on;				// Color on state
    CNString color_off;				// Color off state
    int *b_colors;
    int bsize, rows, cols, width, height, frame;

    void initialize(int r, int c, int b);
     
  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_EZDBLOCK; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_EZDBLOCK ? TRUE : EZDObject::is_a(desc); }
        
    static EZDBlock *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (EZDBlock *)obj;
#   else
	return (EZDBlock *)( !obj || obj->is_a(CN_EZDBLOCK)
	       ? obj : fatal_type(obj->class_desc(), CN_EZDBLOCK) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new EZDBlock(param) : new EZDBlock; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__EZDBlock_h**/
