//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_                C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_                          N E T W O R K S
 * |_        |_  |_  |_  |_        |_                                C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_                      L I B R A R Y
 *
 * $Id: LREF.c,v 0.22 1994/07/22 09:20:08 cncl-adm Exp cncl-adm $
 *
 * Class: CNLREF --- LRE evaluation F(x) (distribution function)
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "LREF.h"



void CNLREF::put (double rvnach)
{

/************************************************************************/
/* Deklaration der internen Variablen                                   */
/************************************************************************/

struct result *presult;                 /* Hilfszeiger Ergebnistabelle  */
register struct result *start,*end;     /* Hilfszeiger Transcountkorretur*/
register int step;                      /* Hilfe Transcountkorretur     */

nrv++;
CNLRE::rv_sum        += rvnach;
CNLRE::rv_square_sum += rvnach*rvnach;
if (CNLRE::max_value < rvnach) CNLRE::max_value = rvnach; 
else if (CNLRE::min_value > rvnach) CNLRE::min_value = rvnach;  // 03.12.93 (fuss)

if (rvakt >= pr->xlevlim )      /* Werte groesergleich dem akt. Level   */
        {                       /* werden nicht mehr sortiert           */
        verbesser(pfirst,pr,rvakt,rvnach); /* nachbessern der Level */
        }
else
        {
        pr->sortmsize++;
        if (rvnach > pr->xlevlim) /* Falls ein Uebegang auftritt abspeichern */
                {
                pr->transcount++;
                start = pfirst;
                end = pr;
                while((step = (end - start) >> 1) )
                        {
                        presult = start + step;
                        if ( presult->xlevlim < rvnach)
                                {
                                end = presult;
                                }
                        else
                                {
                                start = presult;
                                }
                        }
                start->transcount--; /* ab da gibt es keine Uebergange mehr */
                }

        /* abspeichern der Werte */

        sortquickend->rvakt = rvakt;
        sortquickend->rvnach = rvnach;
        sortquickend++;
        if ( pr->sortmsize >= sortfeldgroesse )
                schaufelum();
        }

/* nur wenn gegisste Anzahl der benoetigten Werte */
if ( nrv > n0 )
        next_level();
rvakt = rvnach;
}

void CNLREF::neusort(struct result *presult)
{

struct sm *end;
register struct sm *dest;
register double neurvakt;
int i;

/* Sortierfeld sortieren */

/* Neugezogene Werte sortieren */

if( (sortquickend - sortquick) > 1)
        quicksort(sortquick,sortquickend-1);

/* Sortierte Werte mit den anderen schon sortierten Werten mischen */

dest = new struct sm[pr->sortmsize + 2];
end = mergesort(dest);

/* alte Liste freigeben */

delete sortmerge;
sortmerge = dest;

/*************************************************************/
/* fehlende Werte in presult besetzen                        */
/*************************************************************/

if ( end == dest) /* Sortierfeld leer */
        {
        phase = END;
        return;
        }

/*****************************************************************/
/* Beim ersten Wert so tun als w"are er der gerade gr"osste Wert */
/*****************************************************************/

if ( pr->xlevlim == MAXDOUBLE)
        {
        pr->nxvalue = 1;
        while ( (end-1)->rvakt == (end - (pr->nxvalue + 1))->rvakt )
                {
                pr->nxvalue++;
                }
        }

if ( (end - dest) < presult->sortmsize )
        {                       /* neues xlevel */
        neurvakt = (end - 1)->rvakt;
        }
else 
        {
        neurvakt = ( dest + presult->sortmsize)->rvakt;
        i = 1;
        if ( neurvakt == pr->xlevlim
          || neurvakt == (end-1)->rvakt && pr->xlevlim == MAXDOUBLE )
                {
                neurvakt = ( end - (pr->nxvalue + 1))->rvakt;
                }
        }

presult->xlevlim = neurvakt;
end->rvakt = neurvakt + 1.0;    // ist immmer ungleich neurvakt;

while(dest->rvakt < neurvakt)
        {
        if (dest->rvnach > neurvakt)
                presult->transcount++;
        dest++;
        }
sortmergeend = dest;

while (dest->rvakt == neurvakt)
        {
        if (dest->rvnach > neurvakt)
                presult->transcount++;
        presult->nxvalue++;
        dest++;
        }

presult->sortmsize = dest - sortmerge ;

/*************************************************************/
/* Sortierfeld Erneuern                                      */
/*************************************************************/

sortquickend = sortquick;
}

struct CNLRE::sm *CNLREF::mergesort(register struct sm *dest)
{

register struct sm *source1 = sortquick;
register struct sm *end1 = sortquickend;
register struct sm *source2 = sortmerge;
register struct sm *end2 = sortmergeend;

if (source1 != end1 && source2 != end2)
        { /* keines der Felder leer */
        while (1)
                {       /* aus beiden Quellen mischen */
                if (source1->rvakt < source2->rvakt)
                        {
                        *dest++ = *source1++ ;
                        if (source1 == end1) break ;
                        }
                else
                        {
                        *dest++ = *source2++ ;
                        if (source2 == end2) break ;
                        }
                }
        }


if (source1 == end1 )
        {                       /* Quelle 1 leer */
        while(source2 < end2 )
                {
                *dest++ = *source2++ ;
                }
        }
else
        {                       /* Quelle 2 leer */
        while(source1 < end1 )
                {
                *dest++ = *source1++ ;
                }
        }
return(dest);
}

void CNLREF::quicksort(struct sm *first,struct sm *last)
{
        register struct sm *left = first -1 ;
        register struct sm *right = last +1 ;
        register double ref = (*first).rvakt;
        static struct sm temp ;

        while (left < right) {
                while ((++left)->rvakt < ref)   ;
                while ((--right)->rvakt > ref)  ;
                if (left < right) {
                        temp = *left ;
                        *left = *right ;
                        *right = temp ;
                }
        }
        left--;
        right++;
        if (first < left) quicksort(first, left) ;
        if (right < last) quicksort(right, last) ;
}
/***********************************************************************/
/*  die Funktion sortiert die Werte in das Ergebnisfeld ein.           */
/*  Das Ergebnisfeld ist differentiell abgelegt.                       */
/*                                                                     */
/*                                                                     */
/***********************************************************************/

void CNLREF::verbesser (struct result *pfirst, struct result *pr,
                      double rvakt,double rvnach)
{

register struct result *start = pfirst;
register struct result *end = pr;
register struct result *presult;
register int step;

while( (step = (end - start) >> 1) )
        {
        presult = start + step ;
        if ( presult->xlevlim <= rvakt)
                {
                end = presult;
                }
        else
                {
                start = presult;
                }
        }

if (end->xlevlim == rvakt)
        {
        end->nxvalue++;
        }
else
        {
        end--;
        }
end->sortmsize++;

if (rvnach > end->xlevlim)
        {
        end->transcount++;
        start = pfirst;
        while( (step = end - start) > 1)
                {
                presult = start + (step >> 1);
                if ( presult->xlevlim < rvnach)
                        {
                        end = presult;
                        }
                else
                        {
                        start = presult;
                        }
                }
        start->transcount--;
        }
}


/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNLREF
static CNClass CNLREF_desc("CNLREF", "$Revision: 0.22 $",
                          CNLREF::new_object);

// "Type" for type checking functions
CNClassDesc CN_LREF = &CNLREF_desc;
