//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: SDLSignal.h,v 0.22 1994/07/22 09:21:42 cncl-adm Exp cncl-adm $
 *
 * Class: CNSDLSignal --- ...
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#ifndef __CNSDLSignal_h
#define __CNSDLSignal_h

/*
   SDLSignal is an enhancement to the Event class. Since in this form of
   SDL simulation the EventHandler pointers sender and receiver both contain
   the SDLManger's address another method had to be developed to identify
   the sending and the receiving process.
*/

#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Event.h>		// Base class

#include <stddef.h>

extern CNClassDesc CN_SDLSIGNAL;	// Class CNSDLSignal description

typedef int PId;
typedef int SignalType;

class CNEventHandler;
class CNSDLManager;

/*
 * The class CNSDLSignal
 */

class CNSDLSignal : public CNEvent
{
    friend class CNSDLManager;
    
  private:
    enum { default_max_signals=100 };
    
  public:
    // Get/set maximum # of signals. set_max_signals() must be called before
    // any signal is created.
    static unsigned long get_max_signals();
    static void set_max_signals(unsigned long n);
 
  public:
    PId sender() {return s_sender;}     
    void sender(PId s) {s_sender=s;}
    
    PId receiver() {return s_receiver;}
    void receiver(PId r) {s_receiver=r;}

    int system() {return s_system;}
    
    // Operator new/delete
    static void *operator new(size_t);
    static void  operator delete(void *);
    
    // Private members
  private:
    static CNSDLSignal *pool;               // Memory area for events
    static unsigned long pool_size;         // Size of event pool
    static unsigned long next_free;         // Index of next free event
    // sig_id == 0 indicates that the event in the event pool is not used

    long sig_id;

     PId s_sender;   // PId of the sending process
     PId s_receiver; // PId of the target process
    
    int s_system;   // describe system (for environment)
    
    /***** Constructors ******************************************************/
  public:
    CNSDLSignal():CNEvent(0, NIL, NIL),s_sender(0),s_receiver(0),
        s_system(0) {}// Default constructor
    CNSDLSignal(CNParam *param) {}			// CNParam constructor

    CNSDLSignal(SignalType name, CNSimTime t, PId s, PId r, int sy, CNObject* data=NIL)
    :CNEvent(name, NIL, NIL, t, data),s_sender(s),s_receiver(r),s_system(sy)
    {} // constructor
    
    CNSDLSignal(SignalType name, CNSimTime t, CNEventHandler *se, CNEventHandler *re,
    PId s, PId r, int sy, CNObject *data=NIL):CNEvent(name, se, re, t, data),
    s_sender(s),s_receiver(r),s_system(sy)
    {} // constructor

  private:
    ~CNSDLSignal() {}
        
    /***** Member functions required by CNCL *********************************/
  public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_SDLSIGNAL;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_SDLSIGNAL ? TRUE : CNEvent::is_a(desc);
    };
        
    static CNSDLSignal *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
        return (CNSDLSignal *)obj;
#   else
        return (CNSDLSignal *)( !obj || obj->is_a(CN_SDLSIGNAL)
               ? obj : fatal_type(obj->class_desc(), CN_SDLSIGNAL) );
#   endif
    }
    
    // CNObject creation
    static CNObject *new_object(CNParam *param = NIL)
    { return param ? new CNSDLSignal(param) : new CNSDLSignal; }
       
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__CNSDLSignal_h**/
