//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: SDLSignal.c,v 0.22 1994/07/22 09:21:42 cncl-adm Exp cncl-adm $
 *
 * Class: CNSDLSignal --- ...
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "SDLSignal.h"


/*
 * Operator new and delete
 */
CNSDLSignal  *CNSDLSignal::pool = NIL;
unsigned long CNSDLSignal::next_free = 0;
unsigned long CNSDLSignal::pool_size = CNSDLSignal::default_max_signals;
  
  
unsigned long CNSDLSignal::get_max_signals()
{
    return pool_size;
}
      
      
void CNSDLSignal::set_max_signals(unsigned long n)
{
    if(pool != NIL)
        error(NIL, "CNSDLSignal: ", "can't set max. # of signals now");
    else
        pool_size = n;
}


void *CNSDLSignal::operator new(size_t s)
{
    /*
     * Initialize pool
     */
    if(pool == NIL)
    {
        pool = ::new CNSDLSignal [pool_size];
        for(unsigned long i=0; i<pool_size; i++)
            pool[i].sig_id = 0;          // Free
        next_free = 0;
    }

    if(next_free == pool_size)
    {
        /*
         * No more free signals in event pool
         */
        fatal(NIL, "CNSDLSignal: ", "no more free events");
        /**NOT REACHED**/
        return NIL;
    }
    CNSDLSignal *p = pool + next_free;
    p->sig_id = -1;                   // Mark as used
    
    /*
     * Search for next free event and set next_free
     */
    /* Search towards end of pool */
    for(next_free++; next_free<pool_size; next_free++)
        if(pool[next_free].sig_id == 0)
            break;
    if(next_free == pool_size)
    {
        /* Search from start of pool */
        for(next_free=0; next_free<pool_size; next_free++)
            if(pool[next_free].sig_id == 0)
                break;
    }
    
    return p;
}


void CNSDLSignal::operator delete(void *p)
{
    CNSDLSignal *ev = (CNSDLSignal *)p;
    
    ev->sig_id = 0;                      // Mark as free
}



/***** Default I/O member function for CNCL classes **************************/

// Normal output
void CNSDLSignal::print(ostream &strm) const
{
    strm << "\nSDLSignal" << "\nSender " << s_sender << "Receiver " 
         << s_receiver << "\nSystem " << s_system << endl;
    CNEvent::print();
}

// Debug output
void CNSDLSignal::dump(ostream &strm) const
{
    strm << "CNSDLSignal { $Revision: 0.22 $ ..."
	 << " }" << endl;
    strm << "\nSender " << s_sender << "Receiver " 
         << s_receiver << "\nSystem " << s_system << endl;
    CNEvent::print();
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class CNSDLSignal
static CNClass CNSDLSignal_desc("CNSDLSignal", "$Revision: 0.22 $",
			    CNSDLSignal::new_object);

// "Type" for type checking functions
CNClassDesc CN_SDLSIGNAL = &CNSDLSignal_desc;

