//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: SDLProcessData.c,v 0.22 1994/07/22 09:21:42 cncl-adm Exp cncl-adm $
 *
 * Class: CNSDLProcessData --- ...
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "SDLProcessData.h"

CNSDLProcessData::CNSDLProcessData(PId se, ProcessType pt, int pn, 
                                   bool uses_save, bool uses_timer)
{
    p_self = se; p_type = pt; p_number = pn;
    p_offspring = 0; p_sender = 0;
    if (uses_save) save_list = new CNDLList; else save_list = NIL;
    if (uses_timer) p_timer = new CNSDLTimer; else p_timer = NIL;
}



void CNSDLProcessData::save(CNSDLSignal *sig)
{
    save_list->append( sig );
}


void CNSDLProcessData::clear_savelist()
{
    CNDLObject *saved_sig = save_list->first();
    while (saved_sig)
    {
        saved_sig = save_list->delete_object(saved_sig);
    }
}


/***** Default I/O member function for CNCL classes **************************/

// Normal output
void CNSDLProcessData::print(ostream &strm) const
{
    strm << "\nSDLProcessData" << "\nPId's: self = " << p_self
         << " parent = " << p_parent << " offspring = " << p_offspring 
         << " sender = " << p_sender << endl;
}

// Debug output
void CNSDLProcessData::dump(ostream &strm) const
{
    strm << "CNSDLProcessData { $Revision: 0.22 $ ..."
	 << " }" << endl;
    strm << "\nSDLProcessData" << "\nPId's: self = " << p_self
         << " parent = " << p_parent << " offspring = " << p_offspring 
         << " sender = " << p_sender << endl;
    strm << "\ntype = " << p_type << " max. number of processes = " 
         << p_number << endl;   
    strm << "\nsave-list:" << endl;
        if (save_list) save_list->dump();
    strm << "\ntimer:" << endl; 
        if (p_timer) p_timer->dump() ;               
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class CNSDLProcessData
static CNClass CNSDLProcessData_desc("CNSDLProcessData", "$Revision: 0.22 $",
			    CNSDLProcessData::new_object);

// "Type" for type checking functions
CNClassDesc CN_SDLPROCESSDATA = &CNSDLProcessData_desc;

