//*BHEADER* :ts=8  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: SDLProcess.c,v 0.22 1994/07/22 09:21:42 cncl-adm Exp cncl-adm $
 *
 * Class: CNSDLProcess --- ...
 *
 *****************************************************************************
 * Copyright (C) 1992/1993   Communication Networks
 *                           Aachen University of Technology
 *                           Kopernikusstr. 16
 *                           W-5100 Aachen
 *                           Germany
 *                           Email: mj@dfv.rwth-aachen.de (Martin Junius)
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 **EHEADER********************************************************************/

#include "SDLProcess.h"


CNSDLProcess::CNSDLProcess(char *pname, CNSDLManager *SM, int typ)
{
    name = pname; stack = NIL;
    System = SM; p_type = typ;
    handler = &CNSDLProcess::process;
    actual_state = 0; hc_fpc = 0;
}




char* CNSDLProcess::get_name() const
{
    return name;
}


// actual simulation time
CNSimTime CNSDLProcess::now()
{
    return System->now();
}


// procedure call
void CNSDLProcess::procedure(PMF fp)
{
    stack_i *h = stack;   // raise stack
    stack = new stack_i;
    stack->stack_end = h;
    
    stack->old_state = state();  // save current state (and more)
    stack->old_handler = handler;
    stack->helpval = hc_fpc;
    
    handler = fp;  // give control to procedure
    state(0);      // and set it to initial state
    return;
}

void CNSDLProcess::return_from_procedure()
{
    handler = stack->old_handler;  // return control to caller
    state(stack->old_state);       // restore state (and more)
    hc_fpc = stack->helpval + 1;
    
    stack_i *h = stack->stack_end; // lower stack
    delete stack;
    stack = h;
    return;
}

    
    

// process function must be defined in derived class
virtual int CNSDLProcess::process(int signal)
{
    error(err_fatal,"CNSDLProcess ","no function process defined.");
    return 0;
}



/***** Default I/O member function for CNCL classes **************************/

// Normal output
void CNSDLProcess::print(ostream &strm) const
{
    strm << "\nSDLProcess" << "\nName " << name << " state = " 
         << actual_state << endl;
}

// Debug output
void CNSDLProcess::dump(ostream &strm) const
{
    strm << "CNSDLProcess { $Revision: 0.22 $ ..."
	 << " }" << endl;
    strm << "Name " << name << " state = " << actual_state << "type = " 
         << p_type << endl;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class CNSDLProcess
static CNClass CNSDLProcess_desc("CNSDLProcess", "$Revision: 0.22 $",
			    CNSDLProcess::new_object);

// "Type" for type checking functions
CNClassDesc CN_SDLPROCESS = &CNSDLProcess_desc;


